/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateAutoScalingGroupRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateAutoScalingGroupRequest.Builder, UpdateAutoScalingGroupRequest> {
    private final String autoScalingGroupName;

    private final String launchConfigurationName;

    private final Integer minSize;

    private final Integer maxSize;

    private final Integer desiredCapacity;

    private final Integer defaultCooldown;

    private final List<String> availabilityZones;

    private final String healthCheckType;

    private final Integer healthCheckGracePeriod;

    private final String placementGroup;

    private final String vpcZoneIdentifier;

    private final List<String> terminationPolicies;

    private final Boolean newInstancesProtectedFromScaleIn;

    private UpdateAutoScalingGroupRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredCapacity = builder.desiredCapacity;
        this.defaultCooldown = builder.defaultCooldown;
        this.availabilityZones = builder.availabilityZones;
        this.healthCheckType = builder.healthCheckType;
        this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
        this.placementGroup = builder.placementGroup;
        this.vpcZoneIdentifier = builder.vpcZoneIdentifier;
        this.terminationPolicies = builder.terminationPolicies;
        this.newInstancesProtectedFromScaleIn = builder.newInstancesProtectedFromScaleIn;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The name of the launch configuration.
     * </p>
     * 
     * @return The name of the launch configuration.
     */
    public String launchConfigurationName() {
        return launchConfigurationName;
    }

    /**
     * <p>
     * The minimum size of the Auto Scaling group.
     * </p>
     * 
     * @return The minimum size of the Auto Scaling group.
     */
    public Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The maximum size of the Auto Scaling group.
     * </p>
     * 
     * @return The maximum size of the Auto Scaling group.
     */
    public Integer maxSize() {
        return maxSize;
    }

    /**
     * <p>
     * The number of EC2 instances that should be running in the Auto Scaling group. This number must be greater than or
     * equal to the minimum size of the group and less than or equal to the maximum size of the group.
     * </p>
     * 
     * @return The number of EC2 instances that should be running in the Auto Scaling group. This number must be greater
     *         than or equal to the minimum size of the group and less than or equal to the maximum size of the group.
     */
    public Integer desiredCapacity() {
        return desiredCapacity;
    }

    /**
     * <p>
     * The amount of time, in seconds, after a scaling activity completes before another scaling activity can start. The
     * default is 300.
     * </p>
     * <p>
     * For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto
     * Scaling Cooldowns</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The amount of time, in seconds, after a scaling activity completes before another scaling activity can
     *         start. The default is 300.</p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling Cooldowns</a>
     *         in the <i>Auto Scaling User Guide</i>.
     */
    public Integer defaultCooldown() {
        return defaultCooldown;
    }

    /**
     * <p>
     * One or more Availability Zones for the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more Availability Zones for the group.
     */
    public List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>.
     * </p>
     * 
     * @return The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>.
     */
    public String healthCheckType() {
        return healthCheckType;
    }

    /**
     * <p>
     * The amount of time, in seconds, that Auto Scaling waits before checking the health status of an EC2 instance that
     * has come into service. The default is 0.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/healthcheck.html">Health Checks</a> in the <i>Auto
     * Scaling User Guide</i>.
     * </p>
     * 
     * @return The amount of time, in seconds, that Auto Scaling waits before checking the health status of an EC2
     *         instance that has come into service. The default is 0.</p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/healthcheck.html">Health Checks</a> in the
     *         <i>Auto Scaling User Guide</i>.
     */
    public Integer healthCheckGracePeriod() {
        return healthCheckGracePeriod;
    }

    /**
     * <p>
     * The name of the placement group into which you'll launch your instances, if any. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement Groups</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return The name of the placement group into which you'll launch your instances, if any. For more information,
     *         see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement
     *         Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public String placementGroup() {
        return placementGroup;
    }

    /**
     * <p>
     * The ID of the subnet, if you are launching into a VPC. You can specify several subnets in a comma-separated list.
     * </p>
     * <p>
     * When you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, ensure that the subnets'
     * Availability Zones match the values you specify for <code>AvailabilityZones</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling Instances
     * in a VPC</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The ID of the subnet, if you are launching into a VPC. You can specify several subnets in a
     *         comma-separated list.</p>
     *         <p>
     *         When you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, ensure that the
     *         subnets' Availability Zones match the values you specify for <code>AvailabilityZones</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling
     *         Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.
     */
    public String vpcZoneIdentifier() {
        return vpcZoneIdentifier;
    }

    /**
     * <p>
     * A standalone termination policy or a list of termination policies used to select the instance to terminate. The
     * policies are executed in the order that they are listed.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-termination.html">Controlling Which
     * Instances Auto Scaling Terminates During Scale In</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A standalone termination policy or a list of termination policies used to select the instance to
     *         terminate. The policies are executed in the order that they are listed.</p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-termination.html">Controlling
     *         Which Instances Auto Scaling Terminates During Scale In</a> in the <i>Auto Scaling User Guide</i>.
     */
    public List<String> terminationPolicies() {
        return terminationPolicies;
    }

    /**
     * <p>
     * Indicates whether newly launched instances are protected from termination by Auto Scaling when scaling in.
     * </p>
     * 
     * @return Indicates whether newly launched instances are protected from termination by Auto Scaling when scaling
     *         in.
     */
    public Boolean newInstancesProtectedFromScaleIn() {
        return newInstancesProtectedFromScaleIn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((autoScalingGroupName() == null) ? 0 : autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + ((launchConfigurationName() == null) ? 0 : launchConfigurationName().hashCode());
        hashCode = 31 * hashCode + ((minSize() == null) ? 0 : minSize().hashCode());
        hashCode = 31 * hashCode + ((maxSize() == null) ? 0 : maxSize().hashCode());
        hashCode = 31 * hashCode + ((desiredCapacity() == null) ? 0 : desiredCapacity().hashCode());
        hashCode = 31 * hashCode + ((defaultCooldown() == null) ? 0 : defaultCooldown().hashCode());
        hashCode = 31 * hashCode + ((availabilityZones() == null) ? 0 : availabilityZones().hashCode());
        hashCode = 31 * hashCode + ((healthCheckType() == null) ? 0 : healthCheckType().hashCode());
        hashCode = 31 * hashCode + ((healthCheckGracePeriod() == null) ? 0 : healthCheckGracePeriod().hashCode());
        hashCode = 31 * hashCode + ((placementGroup() == null) ? 0 : placementGroup().hashCode());
        hashCode = 31 * hashCode + ((vpcZoneIdentifier() == null) ? 0 : vpcZoneIdentifier().hashCode());
        hashCode = 31 * hashCode + ((terminationPolicies() == null) ? 0 : terminationPolicies().hashCode());
        hashCode = 31 * hashCode
                + ((newInstancesProtectedFromScaleIn() == null) ? 0 : newInstancesProtectedFromScaleIn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutoScalingGroupRequest)) {
            return false;
        }
        UpdateAutoScalingGroupRequest other = (UpdateAutoScalingGroupRequest) obj;
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.launchConfigurationName() == null ^ this.launchConfigurationName() == null) {
            return false;
        }
        if (other.launchConfigurationName() != null && !other.launchConfigurationName().equals(this.launchConfigurationName())) {
            return false;
        }
        if (other.minSize() == null ^ this.minSize() == null) {
            return false;
        }
        if (other.minSize() != null && !other.minSize().equals(this.minSize())) {
            return false;
        }
        if (other.maxSize() == null ^ this.maxSize() == null) {
            return false;
        }
        if (other.maxSize() != null && !other.maxSize().equals(this.maxSize())) {
            return false;
        }
        if (other.desiredCapacity() == null ^ this.desiredCapacity() == null) {
            return false;
        }
        if (other.desiredCapacity() != null && !other.desiredCapacity().equals(this.desiredCapacity())) {
            return false;
        }
        if (other.defaultCooldown() == null ^ this.defaultCooldown() == null) {
            return false;
        }
        if (other.defaultCooldown() != null && !other.defaultCooldown().equals(this.defaultCooldown())) {
            return false;
        }
        if (other.availabilityZones() == null ^ this.availabilityZones() == null) {
            return false;
        }
        if (other.availabilityZones() != null && !other.availabilityZones().equals(this.availabilityZones())) {
            return false;
        }
        if (other.healthCheckType() == null ^ this.healthCheckType() == null) {
            return false;
        }
        if (other.healthCheckType() != null && !other.healthCheckType().equals(this.healthCheckType())) {
            return false;
        }
        if (other.healthCheckGracePeriod() == null ^ this.healthCheckGracePeriod() == null) {
            return false;
        }
        if (other.healthCheckGracePeriod() != null && !other.healthCheckGracePeriod().equals(this.healthCheckGracePeriod())) {
            return false;
        }
        if (other.placementGroup() == null ^ this.placementGroup() == null) {
            return false;
        }
        if (other.placementGroup() != null && !other.placementGroup().equals(this.placementGroup())) {
            return false;
        }
        if (other.vpcZoneIdentifier() == null ^ this.vpcZoneIdentifier() == null) {
            return false;
        }
        if (other.vpcZoneIdentifier() != null && !other.vpcZoneIdentifier().equals(this.vpcZoneIdentifier())) {
            return false;
        }
        if (other.terminationPolicies() == null ^ this.terminationPolicies() == null) {
            return false;
        }
        if (other.terminationPolicies() != null && !other.terminationPolicies().equals(this.terminationPolicies())) {
            return false;
        }
        if (other.newInstancesProtectedFromScaleIn() == null ^ this.newInstancesProtectedFromScaleIn() == null) {
            return false;
        }
        if (other.newInstancesProtectedFromScaleIn() != null
                && !other.newInstancesProtectedFromScaleIn().equals(this.newInstancesProtectedFromScaleIn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (launchConfigurationName() != null) {
            sb.append("LaunchConfigurationName: ").append(launchConfigurationName()).append(",");
        }
        if (minSize() != null) {
            sb.append("MinSize: ").append(minSize()).append(",");
        }
        if (maxSize() != null) {
            sb.append("MaxSize: ").append(maxSize()).append(",");
        }
        if (desiredCapacity() != null) {
            sb.append("DesiredCapacity: ").append(desiredCapacity()).append(",");
        }
        if (defaultCooldown() != null) {
            sb.append("DefaultCooldown: ").append(defaultCooldown()).append(",");
        }
        if (availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(availabilityZones()).append(",");
        }
        if (healthCheckType() != null) {
            sb.append("HealthCheckType: ").append(healthCheckType()).append(",");
        }
        if (healthCheckGracePeriod() != null) {
            sb.append("HealthCheckGracePeriod: ").append(healthCheckGracePeriod()).append(",");
        }
        if (placementGroup() != null) {
            sb.append("PlacementGroup: ").append(placementGroup()).append(",");
        }
        if (vpcZoneIdentifier() != null) {
            sb.append("VPCZoneIdentifier: ").append(vpcZoneIdentifier()).append(",");
        }
        if (terminationPolicies() != null) {
            sb.append("TerminationPolicies: ").append(terminationPolicies()).append(",");
        }
        if (newInstancesProtectedFromScaleIn() != null) {
            sb.append("NewInstancesProtectedFromScaleIn: ").append(newInstancesProtectedFromScaleIn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateAutoScalingGroupRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The name of the launch configuration.
         * </p>
         * 
         * @param launchConfigurationName
         *        The name of the launch configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationName(String launchConfigurationName);

        /**
         * <p>
         * The minimum size of the Auto Scaling group.
         * </p>
         * 
         * @param minSize
         *        The minimum size of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The maximum size of the Auto Scaling group.
         * </p>
         * 
         * @param maxSize
         *        The maximum size of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);

        /**
         * <p>
         * The number of EC2 instances that should be running in the Auto Scaling group. This number must be greater
         * than or equal to the minimum size of the group and less than or equal to the maximum size of the group.
         * </p>
         * 
         * @param desiredCapacity
         *        The number of EC2 instances that should be running in the Auto Scaling group. This number must be
         *        greater than or equal to the minimum size of the group and less than or equal to the maximum size of
         *        the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCapacity(Integer desiredCapacity);

        /**
         * <p>
         * The amount of time, in seconds, after a scaling activity completes before another scaling activity can start.
         * The default is 300.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling Cooldowns</a> in
         * the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param defaultCooldown
         *        The amount of time, in seconds, after a scaling activity completes before another scaling activity can
         *        start. The default is 300.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling
         *        Cooldowns</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCooldown(Integer defaultCooldown);

        /**
         * <p>
         * One or more Availability Zones for the group.
         * </p>
         * 
         * @param availabilityZones
         *        One or more Availability Zones for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * One or more Availability Zones for the group.
         * </p>
         * 
         * @param availabilityZones
         *        One or more Availability Zones for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>.
         * </p>
         * 
         * @param healthCheckType
         *        The service to use for the health checks. The valid values are <code>EC2</code> and <code>ELB</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckType(String healthCheckType);

        /**
         * <p>
         * The amount of time, in seconds, that Auto Scaling waits before checking the health status of an EC2 instance
         * that has come into service. The default is 0.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/healthcheck.html">Health Checks</a> in the
         * <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param healthCheckGracePeriod
         *        The amount of time, in seconds, that Auto Scaling waits before checking the health status of an EC2
         *        instance that has come into service. The default is 0.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/healthcheck.html">Health Checks</a> in
         *        the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckGracePeriod(Integer healthCheckGracePeriod);

        /**
         * <p>
         * The name of the placement group into which you'll launch your instances, if any. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement Groups</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param placementGroup
         *        The name of the placement group into which you'll launch your instances, if any. For more information,
         *        see <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">Placement
         *        Groups</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementGroup(String placementGroup);

        /**
         * <p>
         * The ID of the subnet, if you are launching into a VPC. You can specify several subnets in a comma-separated
         * list.
         * </p>
         * <p>
         * When you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, ensure that the subnets'
         * Availability Zones match the values you specify for <code>AvailabilityZones</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling
         * Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param vpcZoneIdentifier
         *        The ID of the subnet, if you are launching into a VPC. You can specify several subnets in a
         *        comma-separated list.</p>
         *        <p>
         *        When you specify <code>VPCZoneIdentifier</code> with <code>AvailabilityZones</code>, ensure that the
         *        subnets' Availability Zones match the values you specify for <code>AvailabilityZones</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/asg-in-vpc.html">Launching Auto Scaling
         *        Instances in a VPC</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcZoneIdentifier(String vpcZoneIdentifier);

        /**
         * <p>
         * A standalone termination policy or a list of termination policies used to select the instance to terminate.
         * The policies are executed in the order that they are listed.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-termination.html">Controlling Which
         * Instances Auto Scaling Terminates During Scale In</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param terminationPolicies
         *        A standalone termination policy or a list of termination policies used to select the instance to
         *        terminate. The policies are executed in the order that they are listed.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-termination.html"
         *        >Controlling Which Instances Auto Scaling Terminates During Scale In</a> in the <i>Auto Scaling User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicies(Collection<String> terminationPolicies);

        /**
         * <p>
         * A standalone termination policy or a list of termination policies used to select the instance to terminate.
         * The policies are executed in the order that they are listed.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-termination.html">Controlling Which
         * Instances Auto Scaling Terminates During Scale In</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param terminationPolicies
         *        A standalone termination policy or a list of termination policies used to select the instance to
         *        terminate. The policies are executed in the order that they are listed.</p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-termination.html"
         *        >Controlling Which Instances Auto Scaling Terminates During Scale In</a> in the <i>Auto Scaling User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicies(String... terminationPolicies);

        /**
         * <p>
         * Indicates whether newly launched instances are protected from termination by Auto Scaling when scaling in.
         * </p>
         * 
         * @param newInstancesProtectedFromScaleIn
         *        Indicates whether newly launched instances are protected from termination by Auto Scaling when scaling
         *        in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn);
    }

    private static final class BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String launchConfigurationName;

        private Integer minSize;

        private Integer maxSize;

        private Integer desiredCapacity;

        private Integer defaultCooldown;

        private List<String> availabilityZones;

        private String healthCheckType;

        private Integer healthCheckGracePeriod;

        private String placementGroup;

        private String vpcZoneIdentifier;

        private List<String> terminationPolicies;

        private Boolean newInstancesProtectedFromScaleIn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutoScalingGroupRequest model) {
            setAutoScalingGroupName(model.autoScalingGroupName);
            setLaunchConfigurationName(model.launchConfigurationName);
            setMinSize(model.minSize);
            setMaxSize(model.maxSize);
            setDesiredCapacity(model.desiredCapacity);
            setDefaultCooldown(model.defaultCooldown);
            setAvailabilityZones(model.availabilityZones);
            setHealthCheckType(model.healthCheckType);
            setHealthCheckGracePeriod(model.healthCheckGracePeriod);
            setPlacementGroup(model.placementGroup);
            setVPCZoneIdentifier(model.vpcZoneIdentifier);
            setTerminationPolicies(model.terminationPolicies);
            setNewInstancesProtectedFromScaleIn(model.newInstancesProtectedFromScaleIn);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getLaunchConfigurationName() {
            return launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public final Integer getDesiredCapacity() {
            return desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        public final Integer getDefaultCooldown() {
            return defaultCooldown;
        }

        @Override
        public final Builder defaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
            return this;
        }

        public final void setDefaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
        }

        public final Collection<String> getAvailabilityZones() {
            return availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @SafeVarargs
        public final void setAvailabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
        }

        public final String getHealthCheckType() {
            return healthCheckType;
        }

        @Override
        public final Builder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final void setHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }

        public final Integer getHealthCheckGracePeriod() {
            return healthCheckGracePeriod;
        }

        @Override
        public final Builder healthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public final void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
        }

        public final String getPlacementGroup() {
            return placementGroup;
        }

        @Override
        public final Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public final void setPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
        }

        public final String getVPCZoneIdentifier() {
            return vpcZoneIdentifier;
        }

        @Override
        public final Builder vpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
            return this;
        }

        public final void setVPCZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
        }

        public final Collection<String> getTerminationPolicies() {
            return terminationPolicies;
        }

        @Override
        public final Builder terminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminationPolicies(String... terminationPolicies) {
            terminationPolicies(Arrays.asList(terminationPolicies));
            return this;
        }

        public final void setTerminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
        }

        @SafeVarargs
        public final void setTerminationPolicies(String... terminationPolicies) {
            terminationPolicies(Arrays.asList(terminationPolicies));
        }

        public final Boolean getNewInstancesProtectedFromScaleIn() {
            return newInstancesProtectedFromScaleIn;
        }

        @Override
        public final Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        public final void setNewInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
        }

        @Override
        public UpdateAutoScalingGroupRequest build() {
            return new UpdateAutoScalingGroupRequest(this);
        }
    }
}
