/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTagsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeTagsResponse.Builder, DescribeTagsResponse> {
    private final List<TagDescription> tags;

    private final String nextToken;

    private DescribeTagsResponse(BuilderImpl builder) {
        this.tags = builder.tags;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * One or more tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more tags.
     */
    public List<TagDescription> tags() {
        return tags;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResponse)) {
            return false;
        }
        DescribeTagsResponse other = (DescribeTagsResponse) obj;
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeTagsResponse> {
        /**
         * <p>
         * One or more tags.
         * </p>
         * 
         * @param tags
         *        One or more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagDescription> tags);

        /**
         * <p>
         * One or more tags.
         * </p>
         * 
         * @param tags
         *        One or more tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagDescription... tags);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<TagDescription> tags;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsResponse model) {
            setTags(model.tags);
            setNextToken(model.nextToken);
        }

        public final Collection<TagDescription> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<TagDescription> tags) {
            this.tags = TagDescriptionListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagDescription... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<TagDescription> tags) {
            this.tags = TagDescriptionListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(TagDescription... tags) {
            tags(Arrays.asList(tags));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeTagsResponse build() {
            return new DescribeTagsResponse(this);
        }
    }
}
