/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteNotificationConfigurationRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteNotificationConfigurationRequest.Builder, DeleteNotificationConfigurationRequest> {
    private final String autoScalingGroupName;

    private final String topicARN;

    private DeleteNotificationConfigurationRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.topicARN = builder.topicARN;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic.
     */
    public String topicARN() {
        return topicARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((autoScalingGroupName() == null) ? 0 : autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + ((topicARN() == null) ? 0 : topicARN().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNotificationConfigurationRequest)) {
            return false;
        }
        DeleteNotificationConfigurationRequest other = (DeleteNotificationConfigurationRequest) obj;
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.topicARN() == null ^ this.topicARN() == null) {
            return false;
        }
        if (other.topicARN() != null && !other.topicARN().equals(this.topicARN())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (topicARN() != null) {
            sb.append("TopicARN: ").append(topicARN()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteNotificationConfigurationRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic.
         * </p>
         * 
         * @param topicARN
         *        The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicARN(String topicARN);
    }

    private static final class BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String topicARN;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNotificationConfigurationRequest model) {
            setAutoScalingGroupName(model.autoScalingGroupName);
            setTopicARN(model.topicARN);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getTopicARN() {
            return topicARN;
        }

        @Override
        public final Builder topicARN(String topicARN) {
            this.topicARN = topicARN;
            return this;
        }

        public final void setTopicARN(String topicARN) {
            this.topicARN = topicARN;
        }

        @Override
        public DeleteNotificationConfigurationRequest build() {
            return new DeleteNotificationConfigurationRequest(this);
        }
    }
}
