/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling;

import javax.annotation.Generated;
import software.amazon.awssdk.SdkBaseException;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.autoscaling.model.AlreadyExistsException;
import software.amazon.awssdk.services.autoscaling.model.AttachInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingException;
import software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionRequest;
import software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateLaunchConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateLaunchConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.CreateOrUpdateTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.CreateOrUpdateTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteLaunchConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteLaunchConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteLifecycleHookRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteLifecycleHookResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteNotificationConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteNotificationConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.DeletePolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.DeletePolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteScheduledActionRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteScheduledActionResponse;
import software.amazon.awssdk.services.autoscaling.model.DeleteTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.DeleteTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAdjustmentTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAdjustmentTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingNotificationTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingNotificationTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHookTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHookTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHooksRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHooksResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeMetricCollectionTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeMetricCollectionTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingProcessTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingProcessTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTagsResponse;
import software.amazon.awssdk.services.autoscaling.model.DescribeTerminationPolicyTypesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeTerminationPolicyTypesResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachInstancesResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancerTargetGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancerTargetGroupsResponse;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancersRequest;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancersResponse;
import software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionRequest;
import software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionResponse;
import software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionRequest;
import software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionResponse;
import software.amazon.awssdk.services.autoscaling.model.EnterStandbyRequest;
import software.amazon.awssdk.services.autoscaling.model.EnterStandbyResponse;
import software.amazon.awssdk.services.autoscaling.model.ExecutePolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.ExecutePolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.ExitStandbyRequest;
import software.amazon.awssdk.services.autoscaling.model.ExitStandbyResponse;
import software.amazon.awssdk.services.autoscaling.model.InvalidNextTokenException;
import software.amazon.awssdk.services.autoscaling.model.LimitExceededException;
import software.amazon.awssdk.services.autoscaling.model.PutLifecycleHookRequest;
import software.amazon.awssdk.services.autoscaling.model.PutLifecycleHookResponse;
import software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationResponse;
import software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyResponse;
import software.amazon.awssdk.services.autoscaling.model.PutScheduledUpdateGroupActionRequest;
import software.amazon.awssdk.services.autoscaling.model.PutScheduledUpdateGroupActionResponse;
import software.amazon.awssdk.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest;
import software.amazon.awssdk.services.autoscaling.model.RecordLifecycleActionHeartbeatResponse;
import software.amazon.awssdk.services.autoscaling.model.ResourceContentionException;
import software.amazon.awssdk.services.autoscaling.model.ResourceInUseException;
import software.amazon.awssdk.services.autoscaling.model.ResumeProcessesRequest;
import software.amazon.awssdk.services.autoscaling.model.ResumeProcessesResponse;
import software.amazon.awssdk.services.autoscaling.model.ScalingActivityInProgressException;
import software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityRequest;
import software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityResponse;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceHealthRequest;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceHealthResponse;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceProtectionRequest;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceProtectionResponse;
import software.amazon.awssdk.services.autoscaling.model.SuspendProcessesRequest;
import software.amazon.awssdk.services.autoscaling.model.SuspendProcessesResponse;
import software.amazon.awssdk.services.autoscaling.model.TerminateInstanceInAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.TerminateInstanceInAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupResponse;
import software.amazon.awssdk.services.autoscaling.waiters.AutoScalingClientWaiters;

/**
 * Service client for accessing null. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Auto Scaling</fullname>
 * <p>
 * Auto Scaling is designed to automatically launch or terminate EC2 instances based on user-defined policies,
 * schedules, and health checks. Use this service in conjunction with the Amazon CloudWatch and Elastic Load Balancing
 * services.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface AutoScalingClient extends AutoCloseable {
    String SERVICE_NAME = "autoscaling";

    /**
     * Create a {@link AutoScalingClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.DefaultCredentialsProvider}.
     */
    static AutoScalingClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AutoScalingClient}.
     */
    static AutoScalingClientBuilder builder() {
        return new DefaultAutoScalingClientBuilder();
    }

    /**
     * <p>
     * Attaches one or more EC2 instances to the specified Auto Scaling group.
     * </p>
     * <p>
     * When you attach instances, Auto Scaling increases the desired capacity of the group by the number of instances
     * being attached. If the number of instances being attached plus the desired capacity of the group exceeds the
     * maximum size of the group, the operation fails.
     * </p>
     * <p>
     * If there is a Classic Load Balancer attached to your Auto Scaling group, the instances are also registered with
     * the load balancer. If there are target groups attached to your Auto Scaling group, the instances are also
     * registered with the target groups.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/attach-instance-asg.html">Attach EC2 Instances to
     * Your Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @param attachInstancesRequest
     * @return Result of the AttachInstances operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.AttachInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default AttachInstancesResponse attachInstances(AttachInstancesRequest attachInstancesRequest)
            throws ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches one or more target groups to the specified Auto Scaling group.
     * </p>
     * <p>
     * To describe the target groups for an Auto Scaling group, use <a>DescribeLoadBalancerTargetGroups</a>. To detach
     * the target group from the Auto Scaling group, use <a>DetachLoadBalancerTargetGroups</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/attach-load-balancer-asg.html">Attach a Load
     * Balancer to Your Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @param attachLoadBalancerTargetGroupsRequest
     * @return Result of the AttachLoadBalancerTargetGroups operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.AttachLoadBalancerTargetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachLoadBalancerTargetGroupsResponse attachLoadBalancerTargetGroups(
            AttachLoadBalancerTargetGroupsRequest attachLoadBalancerTargetGroupsRequest) throws ResourceContentionException,
            SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches one or more Classic Load Balancers to the specified Auto Scaling group.
     * </p>
     * <p>
     * To attach an Application Load Balancer instead, see <a>AttachLoadBalancerTargetGroups</a>.
     * </p>
     * <p>
     * To describe the load balancers for an Auto Scaling group, use <a>DescribeLoadBalancers</a>. To detach the load
     * balancer from the Auto Scaling group, use <a>DetachLoadBalancers</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/attach-load-balancer-asg.html">Attach a Load
     * Balancer to Your Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @param attachLoadBalancersRequest
     * @return Result of the AttachLoadBalancers operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.AttachLoadBalancers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/AttachLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default AttachLoadBalancersResponse attachLoadBalancers(AttachLoadBalancersRequest attachLoadBalancersRequest)
            throws ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Completes the lifecycle action for the specified token or instance with the specified result.
     * </p>
     * <p>
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * (Optional) Create a Lambda function and a rule that allows CloudWatch Events to invoke your Lambda function when
     * Auto Scaling launches or terminates instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an
     * Amazon SNS topic. The role allows Auto Scaling to publish lifecycle notifications to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you need more time, record the lifecycle action heartbeat to keep the instance in a pending state.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>If you finish before the timeout period ends, complete the lifecycle action.</b>
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/AutoScalingGroupLifecycle.html">Auto Scaling
     * Lifecycle</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @param completeLifecycleActionRequest
     * @return Result of the CompleteLifecycleAction operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.CompleteLifecycleAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CompleteLifecycleAction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompleteLifecycleActionResponse completeLifecycleAction(CompleteLifecycleActionRequest completeLifecycleActionRequest)
            throws ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Auto Scaling group with the specified name and attributes.
     * </p>
     * <p>
     * If you exceed your maximum limit of Auto Scaling groups, which by default is 20 per region, the call fails. For
     * information about viewing and updating this limit, see <a>DescribeAccountLimits</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/AutoScalingGroup.html">Auto Scaling Groups</a> in
     * the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @param createAutoScalingGroupRequest
     * @return Result of the CreateAutoScalingGroup operation returned by the service.
     * @throws AlreadyExistsException
     *         You already have an Auto Scaling group or launch configuration with this name.
     * @throws LimitExceededException
     *         You have already reached a limit for your Auto Scaling resources (for example, groups, launch
     *         configurations, or lifecycle hooks). For more information, see <a>DescribeAccountLimits</a>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.CreateAutoScalingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAutoScalingGroupResponse createAutoScalingGroup(CreateAutoScalingGroupRequest createAutoScalingGroupRequest)
            throws AlreadyExistsException, LimitExceededException, ResourceContentionException, SdkBaseException,
            SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a launch configuration.
     * </p>
     * <p>
     * If you exceed your maximum limit of launch configurations, which by default is 100 per region, the call fails.
     * For information about viewing and updating this limit, see <a>DescribeAccountLimits</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/LaunchConfiguration.html">Launch Configurations</a>
     * in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @param createLaunchConfigurationRequest
     * @return Result of the CreateLaunchConfiguration operation returned by the service.
     * @throws AlreadyExistsException
     *         You already have an Auto Scaling group or launch configuration with this name.
     * @throws LimitExceededException
     *         You have already reached a limit for your Auto Scaling resources (for example, groups, launch
     *         configurations, or lifecycle hooks). For more information, see <a>DescribeAccountLimits</a>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.CreateLaunchConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateLaunchConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLaunchConfigurationResponse createLaunchConfiguration(
            CreateLaunchConfigurationRequest createLaunchConfigurationRequest) throws AlreadyExistsException,
            LimitExceededException, ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates tags for the specified Auto Scaling group.
     * </p>
     * <p>
     * When you specify a tag with a key that already exists, the operation overwrites the previous tag definition, and
     * you do not get an error message.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/autoscaling-tagging.html">Tagging Auto Scaling
     * Groups and Instances</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @param createOrUpdateTagsRequest
     * @return Result of the CreateOrUpdateTags operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Auto Scaling resources (for example, groups, launch
     *         configurations, or lifecycle hooks). For more information, see <a>DescribeAccountLimits</a>.
     * @throws AlreadyExistsException
     *         You already have an Auto Scaling group or launch configuration with this name.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.CreateOrUpdateTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/CreateOrUpdateTags" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateOrUpdateTagsResponse createOrUpdateTags(CreateOrUpdateTagsRequest createOrUpdateTagsRequest)
            throws LimitExceededException, AlreadyExistsException, ResourceContentionException, SdkBaseException,
            SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Auto Scaling group.
     * </p>
     * <p>
     * If the group has instances or scaling activities in progress, you must specify the option to force the deletion
     * in order for it to succeed.
     * </p>
     * <p>
     * If the group has policies, deleting the group deletes the policies, the underlying alarm actions, and any alarm
     * that no longer has an associated action.
     * </p>
     * <p>
     * To remove instances from the Auto Scaling group before deleting it, call <a>DetachInstances</a> with the list of
     * instances and the option to decrement the desired capacity so that Auto Scaling does not launch replacement
     * instances.
     * </p>
     * <p>
     * To terminate all instances before deleting the Auto Scaling group, call <a>UpdateAutoScalingGroup</a> and set the
     * minimum size and desired capacity of the Auto Scaling group to zero.
     * </p>
     * 
     * @param deleteAutoScalingGroupRequest
     * @return Result of the DeleteAutoScalingGroup operation returned by the service.
     * @throws ScalingActivityInProgressException
     *         The operation can't be performed because there are scaling activities in progress.
     * @throws ResourceInUseException
     *         The operation can't be performed because the resource is in use.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DeleteAutoScalingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAutoScalingGroupResponse deleteAutoScalingGroup(DeleteAutoScalingGroupRequest deleteAutoScalingGroupRequest)
            throws ScalingActivityInProgressException, ResourceInUseException, ResourceContentionException, SdkBaseException,
            SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified launch configuration.
     * </p>
     * <p>
     * The launch configuration must not be attached to an Auto Scaling group. When this call completes, the launch
     * configuration is no longer available for use.
     * </p>
     * 
     * @param deleteLaunchConfigurationRequest
     * @return Result of the DeleteLaunchConfiguration operation returned by the service.
     * @throws ResourceInUseException
     *         The operation can't be performed because the resource is in use.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DeleteLaunchConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteLaunchConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLaunchConfigurationResponse deleteLaunchConfiguration(
            DeleteLaunchConfigurationRequest deleteLaunchConfigurationRequest) throws ResourceInUseException,
            ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified lifecycle hook.
     * </p>
     * <p>
     * If there are any outstanding lifecycle actions, they are completed first (<code>ABANDON</code> for launching
     * instances, <code>CONTINUE</code> for terminating instances).
     * </p>
     * 
     * @param deleteLifecycleHookRequest
     * @return Result of the DeleteLifecycleHook operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DeleteLifecycleHook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteLifecycleHook"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLifecycleHookResponse deleteLifecycleHook(DeleteLifecycleHookRequest deleteLifecycleHookRequest)
            throws ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified notification.
     * </p>
     * 
     * @param deleteNotificationConfigurationRequest
     * @return Result of the DeleteNotificationConfiguration operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DeleteNotificationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNotificationConfigurationResponse deleteNotificationConfiguration(
            DeleteNotificationConfigurationRequest deleteNotificationConfigurationRequest) throws ResourceContentionException,
            SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Auto Scaling policy.
     * </p>
     * <p>
     * Deleting a policy deletes the underlying alarm action, but does not delete the alarm, even if it no longer has an
     * associated action.
     * </p>
     * 
     * @param deletePolicyRequest
     * @return Result of the DeletePolicy operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DeletePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeletePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePolicyResponse deletePolicy(DeletePolicyRequest deletePolicyRequest) throws ResourceContentionException,
            SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified scheduled action.
     * </p>
     * 
     * @param deleteScheduledActionRequest
     * @return Result of the DeleteScheduledAction operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DeleteScheduledAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteScheduledAction"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteScheduledActionResponse deleteScheduledAction(DeleteScheduledActionRequest deleteScheduledActionRequest)
            throws ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified tags.
     * </p>
     * 
     * @param deleteTagsRequest
     * @return Result of the DeleteTags operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DeleteTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws ResourceContentionException,
            SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the current Auto Scaling resource limits for your AWS account.
     * </p>
     * <p>
     * For information about requesting an increase in these limits, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">AWS Service Limits</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @param describeAccountLimitsRequest
     * @return Result of the DescribeAccountLimits operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeAccountLimits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsResponse describeAccountLimits() throws ResourceContentionException, SdkBaseException,
            SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the current Auto Scaling resource limits for your AWS account.
     * </p>
     * <p>
     * For information about requesting an increase in these limits, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">AWS Service Limits</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @param describeAccountLimitsRequest
     * @return Result of the DescribeAccountLimits operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeAccountLimits
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAccountLimitsResponse describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest)
            throws ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the policy adjustment types for use with <a>PutScalingPolicy</a>.
     * </p>
     * 
     * @param describeAdjustmentTypesRequest
     * @return Result of the DescribeAdjustmentTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeAdjustmentTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAdjustmentTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAdjustmentTypesResponse describeAdjustmentTypes() throws ResourceContentionException, SdkBaseException,
            SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the policy adjustment types for use with <a>PutScalingPolicy</a>.
     * </p>
     * 
     * @param describeAdjustmentTypesRequest
     * @return Result of the DescribeAdjustmentTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeAdjustmentTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAdjustmentTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAdjustmentTypesResponse describeAdjustmentTypes(DescribeAdjustmentTypesRequest describeAdjustmentTypesRequest)
            throws ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more Auto Scaling groups.
     * </p>
     * 
     * @param describeAutoScalingGroupsRequest
     * @return Result of the DescribeAutoScalingGroups operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeAutoScalingGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingGroupsResponse describeAutoScalingGroups() throws InvalidNextTokenException,
            ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more Auto Scaling groups.
     * </p>
     * 
     * @param describeAutoScalingGroupsRequest
     * @return Result of the DescribeAutoScalingGroups operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeAutoScalingGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingGroupsResponse describeAutoScalingGroups(
            DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) throws InvalidNextTokenException,
            ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more Auto Scaling instances.
     * </p>
     * 
     * @param describeAutoScalingInstancesRequest
     * @return Result of the DescribeAutoScalingInstances operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeAutoScalingInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingInstancesResponse describeAutoScalingInstances() throws InvalidNextTokenException,
            ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more Auto Scaling instances.
     * </p>
     * 
     * @param describeAutoScalingInstancesRequest
     * @return Result of the DescribeAutoScalingInstances operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeAutoScalingInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingInstancesResponse describeAutoScalingInstances(
            DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) throws InvalidNextTokenException,
            ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the notification types that are supported by Auto Scaling.
     * </p>
     * 
     * @param describeAutoScalingNotificationTypesRequest
     * @return Result of the DescribeAutoScalingNotificationTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeAutoScalingNotificationTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingNotificationTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingNotificationTypesResponse describeAutoScalingNotificationTypes()
            throws ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the notification types that are supported by Auto Scaling.
     * </p>
     * 
     * @param describeAutoScalingNotificationTypesRequest
     * @return Result of the DescribeAutoScalingNotificationTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeAutoScalingNotificationTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeAutoScalingNotificationTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutoScalingNotificationTypesResponse describeAutoScalingNotificationTypes(
            DescribeAutoScalingNotificationTypesRequest describeAutoScalingNotificationTypesRequest)
            throws ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more launch configurations.
     * </p>
     * 
     * @param describeLaunchConfigurationsRequest
     * @return Result of the DescribeLaunchConfigurations operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeLaunchConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLaunchConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationsResponse describeLaunchConfigurations() throws InvalidNextTokenException,
            ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more launch configurations.
     * </p>
     * 
     * @param describeLaunchConfigurationsRequest
     * @return Result of the DescribeLaunchConfigurations operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeLaunchConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLaunchConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationsResponse describeLaunchConfigurations(
            DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) throws InvalidNextTokenException,
            ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the available types of lifecycle hooks.
     * </p>
     * 
     * @param describeLifecycleHookTypesRequest
     * @return Result of the DescribeLifecycleHookTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeLifecycleHookTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLifecycleHookTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLifecycleHookTypesResponse describeLifecycleHookTypes() throws ResourceContentionException, SdkBaseException,
            SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the available types of lifecycle hooks.
     * </p>
     * 
     * @param describeLifecycleHookTypesRequest
     * @return Result of the DescribeLifecycleHookTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeLifecycleHookTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLifecycleHookTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLifecycleHookTypesResponse describeLifecycleHookTypes(
            DescribeLifecycleHookTypesRequest describeLifecycleHookTypesRequest) throws ResourceContentionException,
            SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the lifecycle hooks for the specified Auto Scaling group.
     * </p>
     * 
     * @param describeLifecycleHooksRequest
     * @return Result of the DescribeLifecycleHooks operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeLifecycleHooks
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLifecycleHooks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLifecycleHooksResponse describeLifecycleHooks(DescribeLifecycleHooksRequest describeLifecycleHooksRequest)
            throws ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the target groups for the specified Auto Scaling group.
     * </p>
     * 
     * @param describeLoadBalancerTargetGroupsRequest
     * @return Result of the DescribeLoadBalancerTargetGroups operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeLoadBalancerTargetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancerTargetGroupsResponse describeLoadBalancerTargetGroups(
            DescribeLoadBalancerTargetGroupsRequest describeLoadBalancerTargetGroupsRequest) throws ResourceContentionException,
            SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the load balancers for the specified Auto Scaling group.
     * </p>
     * <p>
     * Note that this operation describes only Classic Load Balancers. If you have Application Load Balancers, use
     * <a>DescribeLoadBalancerTargetGroups</a> instead.
     * </p>
     * 
     * @param describeLoadBalancersRequest
     * @return Result of the DescribeLoadBalancers operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeLoadBalancers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLoadBalancersResponse describeLoadBalancers(DescribeLoadBalancersRequest describeLoadBalancersRequest)
            throws ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the available CloudWatch metrics for Auto Scaling.
     * </p>
     * <p>
     * Note that the <code>GroupStandbyInstances</code> metric is not returned by default. You must explicitly request
     * this metric when calling <a>EnableMetricsCollection</a>.
     * </p>
     * 
     * @param describeMetricCollectionTypesRequest
     * @return Result of the DescribeMetricCollectionTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeMetricCollectionTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeMetricCollectionTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetricCollectionTypesResponse describeMetricCollectionTypes() throws ResourceContentionException,
            SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the available CloudWatch metrics for Auto Scaling.
     * </p>
     * <p>
     * Note that the <code>GroupStandbyInstances</code> metric is not returned by default. You must explicitly request
     * this metric when calling <a>EnableMetricsCollection</a>.
     * </p>
     * 
     * @param describeMetricCollectionTypesRequest
     * @return Result of the DescribeMetricCollectionTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeMetricCollectionTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeMetricCollectionTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMetricCollectionTypesResponse describeMetricCollectionTypes(
            DescribeMetricCollectionTypesRequest describeMetricCollectionTypesRequest) throws ResourceContentionException,
            SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the notification actions associated with the specified Auto Scaling group.
     * </p>
     * 
     * @param describeNotificationConfigurationsRequest
     * @return Result of the DescribeNotificationConfigurations operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeNotificationConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotificationConfigurationsResponse describeNotificationConfigurations() throws InvalidNextTokenException,
            ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the notification actions associated with the specified Auto Scaling group.
     * </p>
     * 
     * @param describeNotificationConfigurationsRequest
     * @return Result of the DescribeNotificationConfigurations operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeNotificationConfigurations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeNotificationConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNotificationConfigurationsResponse describeNotificationConfigurations(
            DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest)
            throws InvalidNextTokenException, ResourceContentionException, SdkBaseException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the policies for the specified Auto Scaling group.
     * </p>
     * 
     * @param describePoliciesRequest
     * @return Result of the DescribePolicies operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribePolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePoliciesResponse describePolicies() throws InvalidNextTokenException, ResourceContentionException,
            SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the policies for the specified Auto Scaling group.
     * </p>
     * 
     * @param describePoliciesRequest
     * @return Result of the DescribePolicies operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribePolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePoliciesResponse describePolicies(DescribePoliciesRequest describePoliciesRequest)
            throws InvalidNextTokenException, ResourceContentionException, SdkBaseException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more scaling activities for the specified Auto Scaling group.
     * </p>
     * 
     * @param describeScalingActivitiesRequest
     * @return Result of the DescribeScalingActivities operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeScalingActivities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingActivitiesResponse describeScalingActivities() throws InvalidNextTokenException,
            ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more scaling activities for the specified Auto Scaling group.
     * </p>
     * 
     * @param describeScalingActivitiesRequest
     * @return Result of the DescribeScalingActivities operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeScalingActivities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingActivities"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingActivitiesResponse describeScalingActivities(
            DescribeScalingActivitiesRequest describeScalingActivitiesRequest) throws InvalidNextTokenException,
            ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the scaling process types for use with <a>ResumeProcesses</a> and <a>SuspendProcesses</a>.
     * </p>
     * 
     * @param describeScalingProcessTypesRequest
     * @return Result of the DescribeScalingProcessTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeScalingProcessTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingProcessTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingProcessTypesResponse describeScalingProcessTypes() throws ResourceContentionException,
            SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the scaling process types for use with <a>ResumeProcesses</a> and <a>SuspendProcesses</a>.
     * </p>
     * 
     * @param describeScalingProcessTypesRequest
     * @return Result of the DescribeScalingProcessTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeScalingProcessTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScalingProcessTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingProcessTypesResponse describeScalingProcessTypes(
            DescribeScalingProcessTypesRequest describeScalingProcessTypesRequest) throws ResourceContentionException,
            SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the actions scheduled for your Auto Scaling group that haven't run. To describe the actions that have
     * already run, use <a>DescribeScalingActivities</a>.
     * </p>
     * 
     * @param describeScheduledActionsRequest
     * @return Result of the DescribeScheduledActions operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeScheduledActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScheduledActionsResponse describeScheduledActions() throws InvalidNextTokenException,
            ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the actions scheduled for your Auto Scaling group that haven't run. To describe the actions that have
     * already run, use <a>DescribeScalingActivities</a>.
     * </p>
     * 
     * @param describeScheduledActionsRequest
     * @return Result of the DescribeScheduledActions operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeScheduledActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeScheduledActions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScheduledActionsResponse describeScheduledActions(
            DescribeScheduledActionsRequest describeScheduledActionsRequest) throws InvalidNextTokenException,
            ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified tags.
     * </p>
     * <p>
     * You can use filters to limit the results. For example, you can query for the tags for a specific Auto Scaling
     * group. You can specify multiple values for a filter. A tag must match at least one of the specified values for it
     * to be included in the results.
     * </p>
     * <p>
     * You can also specify multiple filters. The result includes information for a particular tag only if it matches
     * all the filters. If there's no match, no special message is returned.
     * </p>
     * 
     * @param describeTagsRequest
     * @return Result of the DescribeTags operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsResponse describeTags() throws InvalidNextTokenException, ResourceContentionException, SdkBaseException,
            SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified tags.
     * </p>
     * <p>
     * You can use filters to limit the results. For example, you can query for the tags for a specific Auto Scaling
     * group. You can specify multiple values for a filter. A tag must match at least one of the specified values for it
     * to be included in the results.
     * </p>
     * <p>
     * You can also specify multiple filters. The result includes information for a particular tag only if it matches
     * all the filters. If there's no match, no special message is returned.
     * </p>
     * 
     * @param describeTagsRequest
     * @return Result of the DescribeTags operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws InvalidNextTokenException,
            ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the termination policies supported by Auto Scaling.
     * </p>
     * 
     * @param describeTerminationPolicyTypesRequest
     * @return Result of the DescribeTerminationPolicyTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeTerminationPolicyTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTerminationPolicyTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTerminationPolicyTypesResponse describeTerminationPolicyTypes() throws ResourceContentionException,
            SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the termination policies supported by Auto Scaling.
     * </p>
     * 
     * @param describeTerminationPolicyTypesRequest
     * @return Result of the DescribeTerminationPolicyTypes operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DescribeTerminationPolicyTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DescribeTerminationPolicyTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTerminationPolicyTypesResponse describeTerminationPolicyTypes(
            DescribeTerminationPolicyTypesRequest describeTerminationPolicyTypesRequest) throws ResourceContentionException,
            SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more instances from the specified Auto Scaling group.
     * </p>
     * <p>
     * After the instances are detached, you can manage them independent of the Auto Scaling group.
     * </p>
     * <p>
     * If you do not specify the option to decrement the desired capacity, Auto Scaling launches instances to replace
     * the ones that are detached.
     * </p>
     * <p>
     * If there is a Classic Load Balancer attached to the Auto Scaling group, the instances are deregistered from the
     * load balancer. If there are target groups attached to the Auto Scaling group, the instances are deregistered from
     * the target groups.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/detach-instance-asg.html">Detach EC2 Instances from
     * Your Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @param detachInstancesRequest
     * @return Result of the DetachInstances operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DetachInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default DetachInstancesResponse detachInstances(DetachInstancesRequest detachInstancesRequest)
            throws ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches one or more target groups from the specified Auto Scaling group.
     * </p>
     * 
     * @param detachLoadBalancerTargetGroupsRequest
     * @return Result of the DetachLoadBalancerTargetGroups operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DetachLoadBalancerTargetGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachLoadBalancerTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default DetachLoadBalancerTargetGroupsResponse detachLoadBalancerTargetGroups(
            DetachLoadBalancerTargetGroupsRequest detachLoadBalancerTargetGroupsRequest) throws ResourceContentionException,
            SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches one or more Classic Load Balancers from the specified Auto Scaling group.
     * </p>
     * <p>
     * Note that this operation detaches only Classic Load Balancers. If you have Application Load Balancers, use
     * <a>DetachLoadBalancerTargetGroups</a> instead.
     * </p>
     * <p>
     * When you detach a load balancer, it enters the <code>Removing</code> state while deregistering the instances in
     * the group. When all instances are deregistered, then you can no longer describe the load balancer using
     * <a>DescribeLoadBalancers</a>. Note that the instances remain running.
     * </p>
     * 
     * @param detachLoadBalancersRequest
     * @return Result of the DetachLoadBalancers operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DetachLoadBalancers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DetachLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    default DetachLoadBalancersResponse detachLoadBalancers(DetachLoadBalancersRequest detachLoadBalancersRequest)
            throws ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables group metrics for the specified Auto Scaling group.
     * </p>
     * 
     * @param disableMetricsCollectionRequest
     * @return Result of the DisableMetricsCollection operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.DisableMetricsCollection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/DisableMetricsCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableMetricsCollectionResponse disableMetricsCollection(
            DisableMetricsCollectionRequest disableMetricsCollectionRequest) throws ResourceContentionException,
            SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables group metrics for the specified Auto Scaling group. For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-monitoring.html">Monitoring Your Auto
     * Scaling Groups and Instances</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @param enableMetricsCollectionRequest
     * @return Result of the EnableMetricsCollection operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.EnableMetricsCollection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnableMetricsCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableMetricsCollectionResponse enableMetricsCollection(EnableMetricsCollectionRequest enableMetricsCollectionRequest)
            throws ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Moves the specified instances into the standby state.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-enter-exit-standby.html">Temporarily Removing
     * Instances from Your Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @param enterStandbyRequest
     * @return Result of the EnterStandby operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.EnterStandby
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/EnterStandby" target="_top">AWS API
     *      Documentation</a>
     */
    default EnterStandbyResponse enterStandby(EnterStandbyRequest enterStandbyRequest) throws ResourceContentionException,
            SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Executes the specified policy.
     * </p>
     * 
     * @param executePolicyRequest
     * @return Result of the ExecutePolicy operation returned by the service.
     * @throws ScalingActivityInProgressException
     *         The operation can't be performed because there are scaling activities in progress.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.ExecutePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ExecutePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default ExecutePolicyResponse executePolicy(ExecutePolicyRequest executePolicyRequest)
            throws ScalingActivityInProgressException, ResourceContentionException, SdkBaseException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Moves the specified instances out of the standby state.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-enter-exit-standby.html">Temporarily Removing
     * Instances from Your Auto Scaling Group</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @param exitStandbyRequest
     * @return Result of the ExitStandby operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.ExitStandby
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ExitStandby" target="_top">AWS API
     *      Documentation</a>
     */
    default ExitStandbyResponse exitStandby(ExitStandbyRequest exitStandbyRequest) throws ResourceContentionException,
            SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a lifecycle hook for the specified Auto Scaling Group.
     * </p>
     * <p>
     * A lifecycle hook tells Auto Scaling that you want to perform an action on an instance that is not actively in
     * service; for example, either when the instance launches or before the instance terminates.
     * </p>
     * <p>
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * (Optional) Create a Lambda function and a rule that allows CloudWatch Events to invoke your Lambda function when
     * Auto Scaling launches or terminates instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an
     * Amazon SNS topic. The role allows Auto Scaling to publish lifecycle notifications to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * If you need more time, record the lifecycle action heartbeat to keep the instance in a pending state.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you finish before the timeout period ends, complete the lifecycle action.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/lifecycle-hooks.html">Auto Scaling Lifecycle
     * Hooks</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * If you exceed your maximum limit of lifecycle hooks, which by default is 50 per Auto Scaling group, the call
     * fails. For information about updating this limit, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">AWS Service Limits</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @param putLifecycleHookRequest
     * @return Result of the PutLifecycleHook operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Auto Scaling resources (for example, groups, launch
     *         configurations, or lifecycle hooks). For more information, see <a>DescribeAccountLimits</a>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.PutLifecycleHook
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutLifecycleHook" target="_top">AWS
     *      API Documentation</a>
     */
    default PutLifecycleHookResponse putLifecycleHook(PutLifecycleHookRequest putLifecycleHookRequest)
            throws LimitExceededException, ResourceContentionException, SdkBaseException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Configures an Auto Scaling group to send notifications when specified events take place. Subscribers to the
     * specified topic can have messages delivered to an endpoint such as a web server or an email address.
     * </p>
     * <p>
     * This configuration overwrites any existing configuration.
     * </p>
     * <p>
     * For more information see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/ASGettingNotifications.html">Getting SNS
     * Notifications When Your Auto Scaling Group Scales</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @param putNotificationConfigurationRequest
     * @return Result of the PutNotificationConfiguration operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Auto Scaling resources (for example, groups, launch
     *         configurations, or lifecycle hooks). For more information, see <a>DescribeAccountLimits</a>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.PutNotificationConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutNotificationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutNotificationConfigurationResponse putNotificationConfiguration(
            PutNotificationConfigurationRequest putNotificationConfigurationRequest) throws LimitExceededException,
            ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a policy for an Auto Scaling group. To update an existing policy, use the existing policy name
     * and set the parameters you want to change. Any existing parameter not changed in an update to an existing policy
     * is not changed in this update request.
     * </p>
     * <p>
     * If you exceed your maximum limit of step adjustments, which by default is 20 per region, the call fails. For
     * information about updating this limit, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">AWS Service Limits</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @param putScalingPolicyRequest
     * @return Result of the PutScalingPolicy operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Auto Scaling resources (for example, groups, launch
     *         configurations, or lifecycle hooks). For more information, see <a>DescribeAccountLimits</a>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.PutScalingPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutScalingPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default PutScalingPolicyResponse putScalingPolicy(PutScalingPolicyRequest putScalingPolicyRequest)
            throws LimitExceededException, ResourceContentionException, SdkBaseException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a scheduled scaling action for an Auto Scaling group. When updating a scheduled scaling
     * action, if you leave a parameter unspecified, the corresponding value remains unchanged.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/schedule_time.html">Scheduled Scaling</a> in the
     * <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @param putScheduledUpdateGroupActionRequest
     * @return Result of the PutScheduledUpdateGroupAction operation returned by the service.
     * @throws AlreadyExistsException
     *         You already have an Auto Scaling group or launch configuration with this name.
     * @throws LimitExceededException
     *         You have already reached a limit for your Auto Scaling resources (for example, groups, launch
     *         configurations, or lifecycle hooks). For more information, see <a>DescribeAccountLimits</a>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.PutScheduledUpdateGroupAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/PutScheduledUpdateGroupAction"
     *      target="_top">AWS API Documentation</a>
     */
    default PutScheduledUpdateGroupActionResponse putScheduledUpdateGroupAction(
            PutScheduledUpdateGroupActionRequest putScheduledUpdateGroupActionRequest) throws AlreadyExistsException,
            LimitExceededException, ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Records a heartbeat for the lifecycle action associated with the specified token or instance. This extends the
     * timeout by the length of time defined using <a>PutLifecycleHook</a>.
     * </p>
     * <p>
     * This step is a part of the procedure for adding a lifecycle hook to an Auto Scaling group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * (Optional) Create a Lambda function and a rule that allows CloudWatch Events to invoke your Lambda function when
     * Auto Scaling launches or terminates instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) Create a notification target and an IAM role. The target can be either an Amazon SQS queue or an
     * Amazon SNS topic. The role allows Auto Scaling to publish lifecycle notifications to the target.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create the lifecycle hook. Specify whether the hook is used when the instances launch or terminate.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>If you need more time, record the lifecycle action heartbeat to keep the instance in a pending state.</b>
     * </p>
     * </li>
     * <li>
     * <p>
     * If you finish before the timeout period ends, complete the lifecycle action.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/AutoScalingGroupLifecycle.html">Auto Scaling
     * Lifecycle</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @param recordLifecycleActionHeartbeatRequest
     * @return Result of the RecordLifecycleActionHeartbeat operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.RecordLifecycleActionHeartbeat
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/RecordLifecycleActionHeartbeat"
     *      target="_top">AWS API Documentation</a>
     */
    default RecordLifecycleActionHeartbeatResponse recordLifecycleActionHeartbeat(
            RecordLifecycleActionHeartbeatRequest recordLifecycleActionHeartbeatRequest) throws ResourceContentionException,
            SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resumes the specified suspended Auto Scaling processes, or all suspended process, for the specified Auto Scaling
     * group.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-suspend-resume-processes.html">Suspending and
     * Resuming Auto Scaling Processes</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @param resumeProcessesRequest
     * @return Result of the ResumeProcesses operation returned by the service.
     * @throws ResourceInUseException
     *         The operation can't be performed because the resource is in use.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.ResumeProcesses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/ResumeProcesses" target="_top">AWS
     *      API Documentation</a>
     */
    default ResumeProcessesResponse resumeProcesses(ResumeProcessesRequest resumeProcessesRequest) throws ResourceInUseException,
            ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the size of the specified Auto Scaling group.
     * </p>
     * <p>
     * For more information about desired capacity, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/WhatIsAutoScaling.html">What Is Auto Scaling?</a>
     * in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @param setDesiredCapacityRequest
     * @return Result of the SetDesiredCapacity operation returned by the service.
     * @throws ScalingActivityInProgressException
     *         The operation can't be performed because there are scaling activities in progress.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.SetDesiredCapacity
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetDesiredCapacity" target="_top">AWS
     *      API Documentation</a>
     */
    default SetDesiredCapacityResponse setDesiredCapacity(SetDesiredCapacityRequest setDesiredCapacityRequest)
            throws ScalingActivityInProgressException, ResourceContentionException, SdkBaseException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Sets the health status of the specified instance.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/healthcheck.html">Health Checks</a> in the <i>Auto
     * Scaling User Guide</i>.
     * </p>
     * 
     * @param setInstanceHealthRequest
     * @return Result of the SetInstanceHealth operation returned by the service.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.SetInstanceHealth
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetInstanceHealth" target="_top">AWS
     *      API Documentation</a>
     */
    default SetInstanceHealthResponse setInstanceHealth(SetInstanceHealthRequest setInstanceHealthRequest)
            throws ResourceContentionException, SdkBaseException, SdkClientException, AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the instance protection settings of the specified instances.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-instance-termination.html#instance-protection"
     * >Instance Protection</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @param setInstanceProtectionRequest
     * @return Result of the SetInstanceProtection operation returned by the service.
     * @throws LimitExceededException
     *         You have already reached a limit for your Auto Scaling resources (for example, groups, launch
     *         configurations, or lifecycle hooks). For more information, see <a>DescribeAccountLimits</a>.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.SetInstanceProtection
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SetInstanceProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default SetInstanceProtectionResponse setInstanceProtection(SetInstanceProtectionRequest setInstanceProtectionRequest)
            throws LimitExceededException, ResourceContentionException, SdkBaseException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Suspends the specified Auto Scaling processes, or all processes, for the specified Auto Scaling group.
     * </p>
     * <p>
     * Note that if you suspend either the <code>Launch</code> or <code>Terminate</code> process types, it can prevent
     * other process types from functioning properly.
     * </p>
     * <p>
     * To resume processes that have been suspended, use <a>ResumeProcesses</a>.
     * </p>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/as-suspend-resume-processes.html">Suspending and
     * Resuming Auto Scaling Processes</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @param suspendProcessesRequest
     * @return Result of the SuspendProcesses operation returned by the service.
     * @throws ResourceInUseException
     *         The operation can't be performed because the resource is in use.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.SuspendProcesses
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/SuspendProcesses" target="_top">AWS
     *      API Documentation</a>
     */
    default SuspendProcessesResponse suspendProcesses(SuspendProcessesRequest suspendProcessesRequest)
            throws ResourceInUseException, ResourceContentionException, SdkBaseException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates the specified instance and optionally adjusts the desired group size.
     * </p>
     * <p>
     * This call simply makes a termination request. The instance is not terminated immediately.
     * </p>
     * 
     * @param terminateInstanceInAutoScalingGroupRequest
     * @return Result of the TerminateInstanceInAutoScalingGroup operation returned by the service.
     * @throws ScalingActivityInProgressException
     *         The operation can't be performed because there are scaling activities in progress.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.TerminateInstanceInAutoScalingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/TerminateInstanceInAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default TerminateInstanceInAutoScalingGroupResponse terminateInstanceInAutoScalingGroup(
            TerminateInstanceInAutoScalingGroupRequest terminateInstanceInAutoScalingGroupRequest)
            throws ScalingActivityInProgressException, ResourceContentionException, SdkBaseException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration for the specified Auto Scaling group.
     * </p>
     * <p>
     * The new settings take effect on any scaling activities after this call returns. Scaling activities that are
     * currently in progress aren't affected.
     * </p>
     * <p>
     * To update an Auto Scaling group with a launch configuration with <code>InstanceMonitoring</code> set to
     * <code>false</code>, you must first disable the collection of group metrics. Otherwise, you will get an error. If
     * you have previously enabled the collection of group metrics, you can disable it using
     * <a>DisableMetricsCollection</a>.
     * </p>
     * <p>
     * Note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you specify a new value for <code>MinSize</code> without specifying a value for <code>DesiredCapacity</code>,
     * and the new <code>MinSize</code> is larger than the current size of the group, we implicitly call
     * <a>SetDesiredCapacity</a> to set the size of the group to the new value of <code>MinSize</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you specify a new value for <code>MaxSize</code> without specifying a value for <code>DesiredCapacity</code>,
     * and the new <code>MaxSize</code> is smaller than the current size of the group, we implicitly call
     * <a>SetDesiredCapacity</a> to set the size of the group to the new value of <code>MaxSize</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * All other optional parameters are left unchanged if not specified.
     * </p>
     * </li>
     * </ul>
     * 
     * @param updateAutoScalingGroupRequest
     * @return Result of the UpdateAutoScalingGroup operation returned by the service.
     * @throws ScalingActivityInProgressException
     *         The operation can't be performed because there are scaling activities in progress.
     * @throws ResourceContentionException
     *         You already have a pending update to an Auto Scaling resource (for example, a group, instance, or load
     *         balancer).
     * @throws SdkBaseException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc)
     * @throws AutoScalingException
     *         Base exception for all service exceptions. Unknown exceptions will be thrown as an instance of this type
     * @sample AutoScalingClient.UpdateAutoScalingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/autoscaling-2011-01-01/UpdateAutoScalingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAutoScalingGroupResponse updateAutoScalingGroup(UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest)
            throws ScalingActivityInProgressException, ResourceContentionException, SdkBaseException, SdkClientException,
            AutoScalingException {
        throw new UnsupportedOperationException();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("autoscaling");
    }

    AutoScalingClientWaiters waiters();
}
