/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.autoscaling.model.Alarm;
import software.amazon.awssdk.services.autoscaling.model.ScalingPolicy;
import software.amazon.awssdk.services.autoscaling.model.StepAdjustment;
import software.amazon.awssdk.services.autoscaling.transform.AlarmUnmarshaller;
import software.amazon.awssdk.services.autoscaling.transform.StepAdjustmentUnmarshaller;

public class ScalingPolicyUnmarshaller
implements Unmarshaller<ScalingPolicy, StaxUnmarshallerContext> {
    private static ScalingPolicyUnmarshaller INSTANCE;

    public ScalingPolicy unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ScalingPolicy.Builder scalingPolicy = ScalingPolicy.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AutoScalingGroupName", targetDepth)) {
                    scalingPolicy.autoScalingGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PolicyName", targetDepth)) {
                    scalingPolicy.policyName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PolicyARN", targetDepth)) {
                    scalingPolicy.policyARN(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PolicyType", targetDepth)) {
                    scalingPolicy.policyType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AdjustmentType", targetDepth)) {
                    scalingPolicy.adjustmentType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MinAdjustmentStep", targetDepth)) {
                    scalingPolicy.minAdjustmentStep(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MinAdjustmentMagnitude", targetDepth)) {
                    scalingPolicy.minAdjustmentMagnitude(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ScalingAdjustment", targetDepth)) {
                    scalingPolicy.scalingAdjustment(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Cooldown", targetDepth)) {
                    scalingPolicy.cooldown(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StepAdjustments", targetDepth)) {
                    scalingPolicy.stepAdjustments(new ArrayList<StepAdjustment>());
                    continue;
                }
                if (context.testExpression("StepAdjustments/member", targetDepth)) {
                    scalingPolicy.stepAdjustments(StepAdjustmentUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MetricAggregationType", targetDepth)) {
                    scalingPolicy.metricAggregationType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EstimatedInstanceWarmup", targetDepth)) {
                    scalingPolicy.estimatedInstanceWarmup(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Alarms", targetDepth)) {
                    scalingPolicy.alarms(new ArrayList<Alarm>());
                    continue;
                }
                if (!context.testExpression("Alarms/member", targetDepth)) continue;
                scalingPolicy.alarms(AlarmUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ScalingPolicy)scalingPolicy.build();
    }

    public static ScalingPolicyUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ScalingPolicyUnmarshaller();
        }
        return INSTANCE;
    }
}

