/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.autoscaling.model.BlockDeviceMapping;
import software.amazon.awssdk.services.autoscaling.model.LaunchConfiguration;
import software.amazon.awssdk.services.autoscaling.transform.BlockDeviceMappingUnmarshaller;
import software.amazon.awssdk.services.autoscaling.transform.InstanceMonitoringUnmarshaller;

public class LaunchConfigurationUnmarshaller
implements Unmarshaller<LaunchConfiguration, StaxUnmarshallerContext> {
    private static LaunchConfigurationUnmarshaller INSTANCE;

    public LaunchConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        LaunchConfiguration.Builder launchConfiguration = LaunchConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("LaunchConfigurationName", targetDepth)) {
                    launchConfiguration.launchConfigurationName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LaunchConfigurationARN", targetDepth)) {
                    launchConfiguration.launchConfigurationARN(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ImageId", targetDepth)) {
                    launchConfiguration.imageId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("KeyName", targetDepth)) {
                    launchConfiguration.keyName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SecurityGroups", targetDepth)) {
                    launchConfiguration.securityGroups(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("SecurityGroups/member", targetDepth)) {
                    launchConfiguration.securityGroups(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClassicLinkVPCId", targetDepth)) {
                    launchConfiguration.classicLinkVPCId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClassicLinkVPCSecurityGroups", targetDepth)) {
                    launchConfiguration.classicLinkVPCSecurityGroups(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("ClassicLinkVPCSecurityGroups/member", targetDepth)) {
                    launchConfiguration.classicLinkVPCSecurityGroups(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("UserData", targetDepth)) {
                    launchConfiguration.userData(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("InstanceType", targetDepth)) {
                    launchConfiguration.instanceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("KernelId", targetDepth)) {
                    launchConfiguration.kernelId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RamdiskId", targetDepth)) {
                    launchConfiguration.ramdiskId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("BlockDeviceMappings", targetDepth)) {
                    launchConfiguration.blockDeviceMappings(new ArrayList<BlockDeviceMapping>());
                    continue;
                }
                if (context.testExpression("BlockDeviceMappings/member", targetDepth)) {
                    launchConfiguration.blockDeviceMappings(BlockDeviceMappingUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("InstanceMonitoring", targetDepth)) {
                    launchConfiguration.instanceMonitoring(InstanceMonitoringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SpotPrice", targetDepth)) {
                    launchConfiguration.spotPrice(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IamInstanceProfile", targetDepth)) {
                    launchConfiguration.iamInstanceProfile(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreatedTime", targetDepth)) {
                    launchConfiguration.createdTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EbsOptimized", targetDepth)) {
                    launchConfiguration.ebsOptimized(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AssociatePublicIpAddress", targetDepth)) {
                    launchConfiguration.associatePublicIpAddress(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("PlacementTenancy", targetDepth)) continue;
                launchConfiguration.placementTenancy(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (LaunchConfiguration)launchConfiguration.build();
    }

    public static LaunchConfigurationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LaunchConfigurationUnmarshaller();
        }
        return INSTANCE;
    }
}

