/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionRequest;
import software.amazon.awssdk.util.StringUtils;

public class EnableMetricsCollectionRequestMarshaller
implements Marshaller<Request<EnableMetricsCollectionRequest>, EnableMetricsCollectionRequest> {
    public Request<EnableMetricsCollectionRequest> marshall(EnableMetricsCollectionRequest enableMetricsCollectionRequest) {
        SdkInternalList metricsList;
        if (enableMetricsCollectionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)enableMetricsCollectionRequest, "AutoScalingClient");
        request.addParameter("Action", "EnableMetricsCollection");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (enableMetricsCollectionRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)enableMetricsCollectionRequest.autoScalingGroupName()));
        }
        if (!(metricsList = (SdkInternalList)enableMetricsCollectionRequest.metrics()).isEmpty() || !metricsList.isAutoConstruct()) {
            int metricsListIndex = 1;
            for (String metricsListValue : metricsList) {
                if (metricsListValue != null) {
                    request.addParameter("Metrics.member." + metricsListIndex, StringUtils.fromString((String)metricsListValue));
                }
                ++metricsListIndex;
            }
        }
        if (enableMetricsCollectionRequest.granularity() != null) {
            request.addParameter("Granularity", StringUtils.fromString((String)enableMetricsCollectionRequest.granularity()));
        }
        return request;
    }
}

