/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.autoscaling.model.BlockDeviceMapping;
import software.amazon.awssdk.services.autoscaling.model.CreateLaunchConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.Ebs;
import software.amazon.awssdk.services.autoscaling.model.InstanceMonitoring;
import software.amazon.awssdk.util.StringUtils;

public class CreateLaunchConfigurationRequestMarshaller
implements Marshaller<Request<CreateLaunchConfigurationRequest>, CreateLaunchConfigurationRequest> {
    public Request<CreateLaunchConfigurationRequest> marshall(CreateLaunchConfigurationRequest createLaunchConfigurationRequest) {
        InstanceMonitoring instanceMonitoring;
        SdkInternalList blockDeviceMappingsList;
        SdkInternalList classicLinkVPCSecurityGroupsList;
        SdkInternalList securityGroupsList;
        if (createLaunchConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createLaunchConfigurationRequest, "AutoScalingClient");
        request.addParameter("Action", "CreateLaunchConfiguration");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLaunchConfigurationRequest.launchConfigurationName() != null) {
            request.addParameter("LaunchConfigurationName", StringUtils.fromString((String)createLaunchConfigurationRequest.launchConfigurationName()));
        }
        if (createLaunchConfigurationRequest.imageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString((String)createLaunchConfigurationRequest.imageId()));
        }
        if (createLaunchConfigurationRequest.keyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString((String)createLaunchConfigurationRequest.keyName()));
        }
        if (!(securityGroupsList = (SdkInternalList)createLaunchConfigurationRequest.securityGroups()).isEmpty() || !securityGroupsList.isAutoConstruct()) {
            int securityGroupsListIndex = 1;
            for (Object securityGroupsListValue : securityGroupsList) {
                if (securityGroupsListValue != null) {
                    request.addParameter("SecurityGroups.member." + securityGroupsListIndex, StringUtils.fromString((String)securityGroupsListValue));
                }
                ++securityGroupsListIndex;
            }
        }
        if (createLaunchConfigurationRequest.classicLinkVPCId() != null) {
            request.addParameter("ClassicLinkVPCId", StringUtils.fromString((String)createLaunchConfigurationRequest.classicLinkVPCId()));
        }
        if (!(classicLinkVPCSecurityGroupsList = (SdkInternalList)createLaunchConfigurationRequest.classicLinkVPCSecurityGroups()).isEmpty() || !classicLinkVPCSecurityGroupsList.isAutoConstruct()) {
            int classicLinkVPCSecurityGroupsListIndex = 1;
            for (String classicLinkVPCSecurityGroupsListValue : classicLinkVPCSecurityGroupsList) {
                if (classicLinkVPCSecurityGroupsListValue != null) {
                    request.addParameter("ClassicLinkVPCSecurityGroups.member." + classicLinkVPCSecurityGroupsListIndex, StringUtils.fromString((String)classicLinkVPCSecurityGroupsListValue));
                }
                ++classicLinkVPCSecurityGroupsListIndex;
            }
        }
        if (createLaunchConfigurationRequest.userData() != null) {
            request.addParameter("UserData", StringUtils.fromString((String)createLaunchConfigurationRequest.userData()));
        }
        if (createLaunchConfigurationRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)createLaunchConfigurationRequest.instanceId()));
        }
        if (createLaunchConfigurationRequest.instanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString((String)createLaunchConfigurationRequest.instanceType()));
        }
        if (createLaunchConfigurationRequest.kernelId() != null) {
            request.addParameter("KernelId", StringUtils.fromString((String)createLaunchConfigurationRequest.kernelId()));
        }
        if (createLaunchConfigurationRequest.ramdiskId() != null) {
            request.addParameter("RamdiskId", StringUtils.fromString((String)createLaunchConfigurationRequest.ramdiskId()));
        }
        if (!(blockDeviceMappingsList = (SdkInternalList)createLaunchConfigurationRequest.blockDeviceMappings()).isEmpty() || !blockDeviceMappingsList.isAutoConstruct()) {
            int blockDeviceMappingsListIndex = 1;
            for (BlockDeviceMapping blockDeviceMappingsListValue : blockDeviceMappingsList) {
                Ebs ebs;
                if (blockDeviceMappingsListValue.virtualName() != null) {
                    request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)blockDeviceMappingsListValue.virtualName()));
                }
                if (blockDeviceMappingsListValue.deviceName() != null) {
                    request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)blockDeviceMappingsListValue.deviceName()));
                }
                if ((ebs = blockDeviceMappingsListValue.ebs()) != null) {
                    if (ebs.snapshotId() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)ebs.snapshotId()));
                    }
                    if (ebs.volumeSize() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)ebs.volumeSize()));
                    }
                    if (ebs.volumeType() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)ebs.volumeType()));
                    }
                    if (ebs.deleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebs.deleteOnTermination()));
                    }
                    if (ebs.iops() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)ebs.iops()));
                    }
                    if (ebs.encrypted() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)ebs.encrypted()));
                    }
                }
                if (blockDeviceMappingsListValue.noDevice() != null) {
                    request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromBoolean((Boolean)blockDeviceMappingsListValue.noDevice()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if ((instanceMonitoring = createLaunchConfigurationRequest.instanceMonitoring()) != null && instanceMonitoring.enabled() != null) {
            request.addParameter("InstanceMonitoring.Enabled", StringUtils.fromBoolean((Boolean)instanceMonitoring.enabled()));
        }
        if (createLaunchConfigurationRequest.spotPrice() != null) {
            request.addParameter("SpotPrice", StringUtils.fromString((String)createLaunchConfigurationRequest.spotPrice()));
        }
        if (createLaunchConfigurationRequest.iamInstanceProfile() != null) {
            request.addParameter("IamInstanceProfile", StringUtils.fromString((String)createLaunchConfigurationRequest.iamInstanceProfile()));
        }
        if (createLaunchConfigurationRequest.ebsOptimized() != null) {
            request.addParameter("EbsOptimized", StringUtils.fromBoolean((Boolean)createLaunchConfigurationRequest.ebsOptimized()));
        }
        if (createLaunchConfigurationRequest.associatePublicIpAddress() != null) {
            request.addParameter("AssociatePublicIpAddress", StringUtils.fromBoolean((Boolean)createLaunchConfigurationRequest.associatePublicIpAddress()));
        }
        if (createLaunchConfigurationRequest.placementTenancy() != null) {
            request.addParameter("PlacementTenancy", StringUtils.fromString((String)createLaunchConfigurationRequest.placementTenancy()));
        }
        return request;
    }
}

