/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class CreateAutoScalingGroupRequestMarshaller
implements Marshaller<Request<CreateAutoScalingGroupRequest>, CreateAutoScalingGroupRequest> {
    public Request<CreateAutoScalingGroupRequest> marshall(CreateAutoScalingGroupRequest createAutoScalingGroupRequest) {
        SdkInternalList tagsList;
        SdkInternalList terminationPoliciesList;
        SdkInternalList targetGroupARNsList;
        SdkInternalList loadBalancerNamesList;
        SdkInternalList availabilityZonesList;
        if (createAutoScalingGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createAutoScalingGroupRequest, "AutoScalingClient");
        request.addParameter("Action", "CreateAutoScalingGroup");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createAutoScalingGroupRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)createAutoScalingGroupRequest.autoScalingGroupName()));
        }
        if (createAutoScalingGroupRequest.launchConfigurationName() != null) {
            request.addParameter("LaunchConfigurationName", StringUtils.fromString((String)createAutoScalingGroupRequest.launchConfigurationName()));
        }
        if (createAutoScalingGroupRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)createAutoScalingGroupRequest.instanceId()));
        }
        if (createAutoScalingGroupRequest.minSize() != null) {
            request.addParameter("MinSize", StringUtils.fromInteger((Integer)createAutoScalingGroupRequest.minSize()));
        }
        if (createAutoScalingGroupRequest.maxSize() != null) {
            request.addParameter("MaxSize", StringUtils.fromInteger((Integer)createAutoScalingGroupRequest.maxSize()));
        }
        if (createAutoScalingGroupRequest.desiredCapacity() != null) {
            request.addParameter("DesiredCapacity", StringUtils.fromInteger((Integer)createAutoScalingGroupRequest.desiredCapacity()));
        }
        if (createAutoScalingGroupRequest.defaultCooldown() != null) {
            request.addParameter("DefaultCooldown", StringUtils.fromInteger((Integer)createAutoScalingGroupRequest.defaultCooldown()));
        }
        if (!(availabilityZonesList = (SdkInternalList)createAutoScalingGroupRequest.availabilityZones()).isEmpty() || !availabilityZonesList.isAutoConstruct()) {
            int availabilityZonesListIndex = 1;
            for (Object availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.member." + availabilityZonesListIndex, StringUtils.fromString((String)availabilityZonesListValue));
                }
                ++availabilityZonesListIndex;
            }
        }
        if (!(loadBalancerNamesList = (SdkInternalList)createAutoScalingGroupRequest.loadBalancerNames()).isEmpty() || !loadBalancerNamesList.isAutoConstruct()) {
            int loadBalancerNamesListIndex = 1;
            for (Object loadBalancerNamesListValue : loadBalancerNamesList) {
                if (loadBalancerNamesListValue != null) {
                    request.addParameter("LoadBalancerNames.member." + loadBalancerNamesListIndex, StringUtils.fromString((String)loadBalancerNamesListValue));
                }
                ++loadBalancerNamesListIndex;
            }
        }
        if (!(targetGroupARNsList = (SdkInternalList)createAutoScalingGroupRequest.targetGroupARNs()).isEmpty() || !targetGroupARNsList.isAutoConstruct()) {
            int targetGroupARNsListIndex = 1;
            for (Object targetGroupARNsListValue : targetGroupARNsList) {
                if (targetGroupARNsListValue != null) {
                    request.addParameter("TargetGroupARNs.member." + targetGroupARNsListIndex, StringUtils.fromString((String)targetGroupARNsListValue));
                }
                ++targetGroupARNsListIndex;
            }
        }
        if (createAutoScalingGroupRequest.healthCheckType() != null) {
            request.addParameter("HealthCheckType", StringUtils.fromString((String)createAutoScalingGroupRequest.healthCheckType()));
        }
        if (createAutoScalingGroupRequest.healthCheckGracePeriod() != null) {
            request.addParameter("HealthCheckGracePeriod", StringUtils.fromInteger((Integer)createAutoScalingGroupRequest.healthCheckGracePeriod()));
        }
        if (createAutoScalingGroupRequest.placementGroup() != null) {
            request.addParameter("PlacementGroup", StringUtils.fromString((String)createAutoScalingGroupRequest.placementGroup()));
        }
        if (createAutoScalingGroupRequest.vpcZoneIdentifier() != null) {
            request.addParameter("VPCZoneIdentifier", StringUtils.fromString((String)createAutoScalingGroupRequest.vpcZoneIdentifier()));
        }
        if (!(terminationPoliciesList = (SdkInternalList)createAutoScalingGroupRequest.terminationPolicies()).isEmpty() || !terminationPoliciesList.isAutoConstruct()) {
            int terminationPoliciesListIndex = 1;
            for (String terminationPoliciesListValue : terminationPoliciesList) {
                if (terminationPoliciesListValue != null) {
                    request.addParameter("TerminationPolicies.member." + terminationPoliciesListIndex, StringUtils.fromString((String)terminationPoliciesListValue));
                }
                ++terminationPoliciesListIndex;
            }
        }
        if (createAutoScalingGroupRequest.newInstancesProtectedFromScaleIn() != null) {
            request.addParameter("NewInstancesProtectedFromScaleIn", StringUtils.fromBoolean((Boolean)createAutoScalingGroupRequest.newInstancesProtectedFromScaleIn()));
        }
        if (!(tagsList = (SdkInternalList)createAutoScalingGroupRequest.tags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.resourceId() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".ResourceId", StringUtils.fromString((String)tagsListValue.resourceId()));
                }
                if (tagsListValue.resourceType() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".ResourceType", StringUtils.fromString((String)tagsListValue.resourceType()));
                }
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                }
                if (tagsListValue.propagateAtLaunch() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".PropagateAtLaunch", StringUtils.fromBoolean((Boolean)tagsListValue.propagateAtLaunch()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

