/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingGroup;
import software.amazon.awssdk.services.autoscaling.model.EnabledMetric;
import software.amazon.awssdk.services.autoscaling.model.Instance;
import software.amazon.awssdk.services.autoscaling.model.SuspendedProcess;
import software.amazon.awssdk.services.autoscaling.model.TagDescription;
import software.amazon.awssdk.services.autoscaling.transform.EnabledMetricUnmarshaller;
import software.amazon.awssdk.services.autoscaling.transform.InstanceUnmarshaller;
import software.amazon.awssdk.services.autoscaling.transform.SuspendedProcessUnmarshaller;
import software.amazon.awssdk.services.autoscaling.transform.TagDescriptionUnmarshaller;

public class AutoScalingGroupUnmarshaller
implements Unmarshaller<AutoScalingGroup, StaxUnmarshallerContext> {
    private static AutoScalingGroupUnmarshaller INSTANCE;

    public AutoScalingGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        AutoScalingGroup.Builder autoScalingGroup = AutoScalingGroup.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AutoScalingGroupName", targetDepth)) {
                    autoScalingGroup.autoScalingGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AutoScalingGroupARN", targetDepth)) {
                    autoScalingGroup.autoScalingGroupARN(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LaunchConfigurationName", targetDepth)) {
                    autoScalingGroup.launchConfigurationName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MinSize", targetDepth)) {
                    autoScalingGroup.minSize(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxSize", targetDepth)) {
                    autoScalingGroup.maxSize(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DesiredCapacity", targetDepth)) {
                    autoScalingGroup.desiredCapacity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DefaultCooldown", targetDepth)) {
                    autoScalingGroup.defaultCooldown(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AvailabilityZones", targetDepth)) {
                    autoScalingGroup.availabilityZones(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("AvailabilityZones/member", targetDepth)) {
                    autoScalingGroup.availabilityZones(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LoadBalancerNames", targetDepth)) {
                    autoScalingGroup.loadBalancerNames(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("LoadBalancerNames/member", targetDepth)) {
                    autoScalingGroup.loadBalancerNames(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TargetGroupARNs", targetDepth)) {
                    autoScalingGroup.targetGroupARNs(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("TargetGroupARNs/member", targetDepth)) {
                    autoScalingGroup.targetGroupARNs(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HealthCheckType", targetDepth)) {
                    autoScalingGroup.healthCheckType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HealthCheckGracePeriod", targetDepth)) {
                    autoScalingGroup.healthCheckGracePeriod(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Instances", targetDepth)) {
                    autoScalingGroup.instances(new ArrayList<Instance>());
                    continue;
                }
                if (context.testExpression("Instances/member", targetDepth)) {
                    autoScalingGroup.instances(InstanceUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreatedTime", targetDepth)) {
                    autoScalingGroup.createdTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SuspendedProcesses", targetDepth)) {
                    autoScalingGroup.suspendedProcesses(new ArrayList<SuspendedProcess>());
                    continue;
                }
                if (context.testExpression("SuspendedProcesses/member", targetDepth)) {
                    autoScalingGroup.suspendedProcesses(SuspendedProcessUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("PlacementGroup", targetDepth)) {
                    autoScalingGroup.placementGroup(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("VPCZoneIdentifier", targetDepth)) {
                    autoScalingGroup.vpcZoneIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EnabledMetrics", targetDepth)) {
                    autoScalingGroup.enabledMetrics(new ArrayList<EnabledMetric>());
                    continue;
                }
                if (context.testExpression("EnabledMetrics/member", targetDepth)) {
                    autoScalingGroup.enabledMetrics(EnabledMetricUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    autoScalingGroup.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Tags", targetDepth)) {
                    autoScalingGroup.tags(new ArrayList<TagDescription>());
                    continue;
                }
                if (context.testExpression("Tags/member", targetDepth)) {
                    autoScalingGroup.tags(TagDescriptionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TerminationPolicies", targetDepth)) {
                    autoScalingGroup.terminationPolicies(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("TerminationPolicies/member", targetDepth)) {
                    autoScalingGroup.terminationPolicies(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("NewInstancesProtectedFromScaleIn", targetDepth)) continue;
                autoScalingGroup.newInstancesProtectedFromScaleIn(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (AutoScalingGroup)autoScalingGroup.build();
    }

    public static AutoScalingGroupUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AutoScalingGroupUnmarshaller();
        }
        return INSTANCE;
    }
}

