/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.autoscaling.model.InstanceIdsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnterStandbyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, EnterStandbyRequest> {
    private final List<String> instanceIds;
    private final String autoScalingGroupName;
    private final Boolean shouldDecrementDesiredCapacity;

    private EnterStandbyRequest(BuilderImpl builder) {
        this.instanceIds = builder.instanceIds;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.shouldDecrementDesiredCapacity = builder.shouldDecrementDesiredCapacity;
    }

    public List<String> instanceIds() {
        return this.instanceIds;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public Boolean shouldDecrementDesiredCapacity() {
        return this.shouldDecrementDesiredCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceIds() == null ? 0 : this.instanceIds().hashCode());
        hashCode = 31 * hashCode + (this.autoScalingGroupName() == null ? 0 : this.autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.shouldDecrementDesiredCapacity() == null ? 0 : this.shouldDecrementDesiredCapacity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnterStandbyRequest)) {
            return false;
        }
        EnterStandbyRequest other = (EnterStandbyRequest)((Object)obj);
        if (other.instanceIds() == null ^ this.instanceIds() == null) {
            return false;
        }
        if (other.instanceIds() != null && !other.instanceIds().equals(this.instanceIds())) {
            return false;
        }
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.shouldDecrementDesiredCapacity() == null ^ this.shouldDecrementDesiredCapacity() == null) {
            return false;
        }
        return other.shouldDecrementDesiredCapacity() == null || other.shouldDecrementDesiredCapacity().equals(this.shouldDecrementDesiredCapacity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceIds() != null) {
            sb.append("InstanceIds: ").append(this.instanceIds()).append(",");
        }
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.shouldDecrementDesiredCapacity() != null) {
            sb.append("ShouldDecrementDesiredCapacity: ").append(this.shouldDecrementDesiredCapacity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> instanceIds = new SdkInternalList();
        private String autoScalingGroupName;
        private Boolean shouldDecrementDesiredCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(EnterStandbyRequest model) {
            this.setInstanceIds(model.instanceIds);
            this.setAutoScalingGroupName(model.autoScalingGroupName);
            this.setShouldDecrementDesiredCapacity(model.shouldDecrementDesiredCapacity);
        }

        public final Collection<String> getInstanceIds() {
            return this.instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            if (this.instanceIds == null) {
                this.instanceIds = new SdkInternalList(instanceIds.length);
            }
            for (String e : instanceIds) {
                this.instanceIds.add(e);
            }
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsCopier.copy(instanceIds);
        }

        @SafeVarargs
        public final void setInstanceIds(String ... instanceIds) {
            if (this.instanceIds == null) {
                this.instanceIds = new SdkInternalList(instanceIds.length);
            }
            for (String e : instanceIds) {
                this.instanceIds.add(e);
            }
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Boolean getShouldDecrementDesiredCapacity() {
            return this.shouldDecrementDesiredCapacity;
        }

        @Override
        public final Builder shouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity) {
            this.shouldDecrementDesiredCapacity = shouldDecrementDesiredCapacity;
            return this;
        }

        public final void setShouldDecrementDesiredCapacity(Boolean shouldDecrementDesiredCapacity) {
            this.shouldDecrementDesiredCapacity = shouldDecrementDesiredCapacity;
        }

        public EnterStandbyRequest build() {
            return new EnterStandbyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnterStandbyRequest> {
        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);

        public Builder autoScalingGroupName(String var1);

        public Builder shouldDecrementDesiredCapacity(Boolean var1);
    }
}

