/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.autoscaling.model.PolicyNamesCopier;
import software.amazon.awssdk.services.autoscaling.model.PolicyTypesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePoliciesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribePoliciesRequest> {
    private final String autoScalingGroupName;
    private final List<String> policyNames;
    private final List<String> policyTypes;
    private final String nextToken;
    private final Integer maxRecords;

    private DescribePoliciesRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.policyNames = builder.policyNames;
        this.policyTypes = builder.policyTypes;
        this.nextToken = builder.nextToken;
        this.maxRecords = builder.maxRecords;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public List<String> policyNames() {
        return this.policyNames;
    }

    public List<String> policyTypes() {
        return this.policyTypes;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.autoScalingGroupName() == null ? 0 : this.autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.policyNames() == null ? 0 : this.policyNames().hashCode());
        hashCode = 31 * hashCode + (this.policyTypes() == null ? 0 : this.policyTypes().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxRecords() == null ? 0 : this.maxRecords().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePoliciesRequest)) {
            return false;
        }
        DescribePoliciesRequest other = (DescribePoliciesRequest)((Object)obj);
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.policyNames() == null ^ this.policyNames() == null) {
            return false;
        }
        if (other.policyNames() != null && !other.policyNames().equals(this.policyNames())) {
            return false;
        }
        if (other.policyTypes() == null ^ this.policyTypes() == null) {
            return false;
        }
        if (other.policyTypes() != null && !other.policyTypes().equals(this.policyTypes())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        return other.maxRecords() == null || other.maxRecords().equals(this.maxRecords());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(this.autoScalingGroupName()).append(",");
        }
        if (this.policyNames() != null) {
            sb.append("PolicyNames: ").append(this.policyNames()).append(",");
        }
        if (this.policyTypes() != null) {
            sb.append("PolicyTypes: ").append(this.policyTypes()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<String> policyNames = new SdkInternalList();
        private List<String> policyTypes = new SdkInternalList();
        private String nextToken;
        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePoliciesRequest model) {
            this.setAutoScalingGroupName(model.autoScalingGroupName);
            this.setPolicyNames(model.policyNames);
            this.setPolicyTypes(model.policyTypes);
            this.setNextToken(model.nextToken);
            this.setMaxRecords(model.maxRecords);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getPolicyNames() {
            return this.policyNames;
        }

        @Override
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNames(String ... policyNames) {
            if (this.policyNames == null) {
                this.policyNames = new SdkInternalList(policyNames.length);
            }
            for (String e : policyNames) {
                this.policyNames.add(e);
            }
            return this;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
        }

        @SafeVarargs
        public final void setPolicyNames(String ... policyNames) {
            if (this.policyNames == null) {
                this.policyNames = new SdkInternalList(policyNames.length);
            }
            for (String e : policyNames) {
                this.policyNames.add(e);
            }
        }

        public final Collection<String> getPolicyTypes() {
            return this.policyTypes;
        }

        @Override
        public final Builder policyTypes(Collection<String> policyTypes) {
            this.policyTypes = PolicyTypesCopier.copy(policyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyTypes(String ... policyTypes) {
            if (this.policyTypes == null) {
                this.policyTypes = new SdkInternalList(policyTypes.length);
            }
            for (String e : policyTypes) {
                this.policyTypes.add(e);
            }
            return this;
        }

        public final void setPolicyTypes(Collection<String> policyTypes) {
            this.policyTypes = PolicyTypesCopier.copy(policyTypes);
        }

        @SafeVarargs
        public final void setPolicyTypes(String ... policyTypes) {
            if (this.policyTypes == null) {
                this.policyTypes = new SdkInternalList(policyTypes.length);
            }
            for (String e : policyTypes) {
                this.policyTypes.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public DescribePoliciesRequest build() {
            return new DescribePoliciesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribePoliciesRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder policyNames(Collection<String> var1);

        public Builder policyNames(String ... var1);

        public Builder policyTypes(Collection<String> var1);

        public Builder policyTypes(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxRecords(Integer var1);
    }
}

