/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.autoscaling.model.MetricCollectionType;
import software.amazon.awssdk.services.autoscaling.model.MetricCollectionTypesCopier;
import software.amazon.awssdk.services.autoscaling.model.MetricGranularityType;
import software.amazon.awssdk.services.autoscaling.model.MetricGranularityTypesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeMetricCollectionTypesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeMetricCollectionTypesResponse> {
    private final List<MetricCollectionType> metrics;
    private final List<MetricGranularityType> granularities;

    private DescribeMetricCollectionTypesResponse(BuilderImpl builder) {
        this.metrics = builder.metrics;
        this.granularities = builder.granularities;
    }

    public List<MetricCollectionType> metrics() {
        return this.metrics;
    }

    public List<MetricGranularityType> granularities() {
        return this.granularities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.metrics() == null ? 0 : this.metrics().hashCode());
        hashCode = 31 * hashCode + (this.granularities() == null ? 0 : this.granularities().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetricCollectionTypesResponse)) {
            return false;
        }
        DescribeMetricCollectionTypesResponse other = (DescribeMetricCollectionTypesResponse)((Object)obj);
        if (other.metrics() == null ^ this.metrics() == null) {
            return false;
        }
        if (other.metrics() != null && !other.metrics().equals(this.metrics())) {
            return false;
        }
        if (other.granularities() == null ^ this.granularities() == null) {
            return false;
        }
        return other.granularities() == null || other.granularities().equals(this.granularities());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.metrics() != null) {
            sb.append("Metrics: ").append(this.metrics()).append(",");
        }
        if (this.granularities() != null) {
            sb.append("Granularities: ").append(this.granularities()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<MetricCollectionType> metrics = new SdkInternalList();
        private List<MetricGranularityType> granularities = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetricCollectionTypesResponse model) {
            this.setMetrics(model.metrics);
            this.setGranularities(model.granularities);
        }

        public final Collection<MetricCollectionType> getMetrics() {
            return this.metrics;
        }

        @Override
        public final Builder metrics(Collection<MetricCollectionType> metrics) {
            this.metrics = MetricCollectionTypesCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(MetricCollectionType ... metrics) {
            if (this.metrics == null) {
                this.metrics = new SdkInternalList(metrics.length);
            }
            for (MetricCollectionType e : metrics) {
                this.metrics.add(e);
            }
            return this;
        }

        public final void setMetrics(Collection<MetricCollectionType> metrics) {
            this.metrics = MetricCollectionTypesCopier.copy(metrics);
        }

        @SafeVarargs
        public final void setMetrics(MetricCollectionType ... metrics) {
            if (this.metrics == null) {
                this.metrics = new SdkInternalList(metrics.length);
            }
            for (MetricCollectionType e : metrics) {
                this.metrics.add(e);
            }
        }

        public final Collection<MetricGranularityType> getGranularities() {
            return this.granularities;
        }

        @Override
        public final Builder granularities(Collection<MetricGranularityType> granularities) {
            this.granularities = MetricGranularityTypesCopier.copy(granularities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder granularities(MetricGranularityType ... granularities) {
            if (this.granularities == null) {
                this.granularities = new SdkInternalList(granularities.length);
            }
            for (MetricGranularityType e : granularities) {
                this.granularities.add(e);
            }
            return this;
        }

        public final void setGranularities(Collection<MetricGranularityType> granularities) {
            this.granularities = MetricGranularityTypesCopier.copy(granularities);
        }

        @SafeVarargs
        public final void setGranularities(MetricGranularityType ... granularities) {
            if (this.granularities == null) {
                this.granularities = new SdkInternalList(granularities.length);
            }
            for (MetricGranularityType e : granularities) {
                this.granularities.add(e);
            }
        }

        public DescribeMetricCollectionTypesResponse build() {
            return new DescribeMetricCollectionTypesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeMetricCollectionTypesResponse> {
        public Builder metrics(Collection<MetricCollectionType> var1);

        public Builder metrics(MetricCollectionType ... var1);

        public Builder granularities(Collection<MetricGranularityType> var1);

        public Builder granularities(MetricGranularityType ... var1);
    }
}

