/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * PutNotificationConfigurationRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutNotificationConfigurationRequestMarshaller implements
        Marshaller<Request<PutNotificationConfigurationRequest>, PutNotificationConfigurationRequest> {

    public Request<PutNotificationConfigurationRequest> marshall(
            PutNotificationConfigurationRequest putNotificationConfigurationRequest) {

        if (putNotificationConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PutNotificationConfigurationRequest> request = new DefaultRequest<PutNotificationConfigurationRequest>(
                putNotificationConfigurationRequest, "AutoScalingClient");
        request.addParameter("Action", "PutNotificationConfiguration");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (putNotificationConfigurationRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName",
                    StringUtils.fromString(putNotificationConfigurationRequest.autoScalingGroupName()));
        }

        if (putNotificationConfigurationRequest.topicARN() != null) {
            request.addParameter("TopicARN", StringUtils.fromString(putNotificationConfigurationRequest.topicARN()));
        }

        software.amazon.awssdk.runtime.SdkInternalList<String> notificationTypesList = (software.amazon.awssdk.runtime.SdkInternalList<String>) putNotificationConfigurationRequest
                .notificationTypes();
        if (!notificationTypesList.isEmpty() || !notificationTypesList.isAutoConstruct()) {
            int notificationTypesListIndex = 1;

            for (String notificationTypesListValue : notificationTypesList) {
                if (notificationTypesListValue != null) {
                    request.addParameter("NotificationTypes.member." + notificationTypesListIndex,
                            StringUtils.fromString(notificationTypesListValue));
                }
                notificationTypesListIndex++;
            }
        }

        return request;
    }

}
