/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * CreateLaunchConfigurationRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateLaunchConfigurationRequestMarshaller implements
        Marshaller<Request<CreateLaunchConfigurationRequest>, CreateLaunchConfigurationRequest> {

    public Request<CreateLaunchConfigurationRequest> marshall(CreateLaunchConfigurationRequest createLaunchConfigurationRequest) {

        if (createLaunchConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateLaunchConfigurationRequest> request = new DefaultRequest<CreateLaunchConfigurationRequest>(
                createLaunchConfigurationRequest, "AutoScalingClient");
        request.addParameter("Action", "CreateLaunchConfiguration");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (createLaunchConfigurationRequest.launchConfigurationName() != null) {
            request.addParameter("LaunchConfigurationName",
                    StringUtils.fromString(createLaunchConfigurationRequest.launchConfigurationName()));
        }

        if (createLaunchConfigurationRequest.imageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString(createLaunchConfigurationRequest.imageId()));
        }

        if (createLaunchConfigurationRequest.keyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString(createLaunchConfigurationRequest.keyName()));
        }

        software.amazon.awssdk.runtime.SdkInternalList<String> securityGroupsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) createLaunchConfigurationRequest
                .securityGroups();
        if (!securityGroupsList.isEmpty() || !securityGroupsList.isAutoConstruct()) {
            int securityGroupsListIndex = 1;

            for (String securityGroupsListValue : securityGroupsList) {
                if (securityGroupsListValue != null) {
                    request.addParameter("SecurityGroups.member." + securityGroupsListIndex,
                            StringUtils.fromString(securityGroupsListValue));
                }
                securityGroupsListIndex++;
            }
        }

        if (createLaunchConfigurationRequest.classicLinkVPCId() != null) {
            request.addParameter("ClassicLinkVPCId", StringUtils.fromString(createLaunchConfigurationRequest.classicLinkVPCId()));
        }

        software.amazon.awssdk.runtime.SdkInternalList<String> classicLinkVPCSecurityGroupsList = (software.amazon.awssdk.runtime.SdkInternalList<String>) createLaunchConfigurationRequest
                .classicLinkVPCSecurityGroups();
        if (!classicLinkVPCSecurityGroupsList.isEmpty() || !classicLinkVPCSecurityGroupsList.isAutoConstruct()) {
            int classicLinkVPCSecurityGroupsListIndex = 1;

            for (String classicLinkVPCSecurityGroupsListValue : classicLinkVPCSecurityGroupsList) {
                if (classicLinkVPCSecurityGroupsListValue != null) {
                    request.addParameter("ClassicLinkVPCSecurityGroups.member." + classicLinkVPCSecurityGroupsListIndex,
                            StringUtils.fromString(classicLinkVPCSecurityGroupsListValue));
                }
                classicLinkVPCSecurityGroupsListIndex++;
            }
        }

        if (createLaunchConfigurationRequest.userData() != null) {
            request.addParameter("UserData", StringUtils.fromString(createLaunchConfigurationRequest.userData()));
        }

        if (createLaunchConfigurationRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(createLaunchConfigurationRequest.instanceId()));
        }

        if (createLaunchConfigurationRequest.instanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString(createLaunchConfigurationRequest.instanceType()));
        }

        if (createLaunchConfigurationRequest.kernelId() != null) {
            request.addParameter("KernelId", StringUtils.fromString(createLaunchConfigurationRequest.kernelId()));
        }

        if (createLaunchConfigurationRequest.ramdiskId() != null) {
            request.addParameter("RamdiskId", StringUtils.fromString(createLaunchConfigurationRequest.ramdiskId()));
        }

        software.amazon.awssdk.runtime.SdkInternalList<BlockDeviceMapping> blockDeviceMappingsList = (software.amazon.awssdk.runtime.SdkInternalList<BlockDeviceMapping>) createLaunchConfigurationRequest
                .blockDeviceMappings();
        if (!blockDeviceMappingsList.isEmpty() || !blockDeviceMappingsList.isAutoConstruct()) {
            int blockDeviceMappingsListIndex = 1;

            for (BlockDeviceMapping blockDeviceMappingsListValue : blockDeviceMappingsList) {

                if (blockDeviceMappingsListValue.virtualName() != null) {
                    request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".VirtualName",
                            StringUtils.fromString(blockDeviceMappingsListValue.virtualName()));
                }

                if (blockDeviceMappingsListValue.deviceName() != null) {
                    request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".DeviceName",
                            StringUtils.fromString(blockDeviceMappingsListValue.deviceName()));
                }

                Ebs ebs = blockDeviceMappingsListValue.ebs();
                if (ebs != null) {

                    if (ebs.snapshotId() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId",
                                StringUtils.fromString(ebs.snapshotId()));
                    }

                    if (ebs.volumeSize() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize",
                                StringUtils.fromInteger(ebs.volumeSize()));
                    }

                    if (ebs.volumeType() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.VolumeType",
                                StringUtils.fromString(ebs.volumeType()));
                    }

                    if (ebs.deleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex
                                + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean(ebs.deleteOnTermination()));
                    }

                    if (ebs.iops() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.Iops",
                                StringUtils.fromInteger(ebs.iops()));
                    }

                    if (ebs.encrypted() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.Encrypted",
                                StringUtils.fromBoolean(ebs.encrypted()));
                    }
                }

                if (blockDeviceMappingsListValue.noDevice() != null) {
                    request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".NoDevice",
                            StringUtils.fromBoolean(blockDeviceMappingsListValue.noDevice()));
                }
                blockDeviceMappingsListIndex++;
            }
        }

        InstanceMonitoring instanceMonitoring = createLaunchConfigurationRequest.instanceMonitoring();
        if (instanceMonitoring != null) {

            if (instanceMonitoring.enabled() != null) {
                request.addParameter("InstanceMonitoring.Enabled", StringUtils.fromBoolean(instanceMonitoring.enabled()));
            }
        }

        if (createLaunchConfigurationRequest.spotPrice() != null) {
            request.addParameter("SpotPrice", StringUtils.fromString(createLaunchConfigurationRequest.spotPrice()));
        }

        if (createLaunchConfigurationRequest.iamInstanceProfile() != null) {
            request.addParameter("IamInstanceProfile",
                    StringUtils.fromString(createLaunchConfigurationRequest.iamInstanceProfile()));
        }

        if (createLaunchConfigurationRequest.ebsOptimized() != null) {
            request.addParameter("EbsOptimized", StringUtils.fromBoolean(createLaunchConfigurationRequest.ebsOptimized()));
        }

        if (createLaunchConfigurationRequest.associatePublicIpAddress() != null) {
            request.addParameter("AssociatePublicIpAddress",
                    StringUtils.fromBoolean(createLaunchConfigurationRequest.associatePublicIpAddress()));
        }

        if (createLaunchConfigurationRequest.placementTenancy() != null) {
            request.addParameter("PlacementTenancy", StringUtils.fromString(createLaunchConfigurationRequest.placementTenancy()));
        }

        return request;
    }

}
