/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a scaling policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ScalingPolicy implements ToCopyableBuilder<ScalingPolicy.Builder, ScalingPolicy> {
    private final String autoScalingGroupName;

    private final String policyName;

    private final String policyARN;

    private final String policyType;

    private final String adjustmentType;

    private final Integer minAdjustmentStep;

    private final Integer minAdjustmentMagnitude;

    private final Integer scalingAdjustment;

    private final Integer cooldown;

    private final List<StepAdjustment> stepAdjustments;

    private final String metricAggregationType;

    private final Integer estimatedInstanceWarmup;

    private final List<Alarm> alarms;

    private ScalingPolicy(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.policyName = builder.policyName;
        this.policyARN = builder.policyARN;
        this.policyType = builder.policyType;
        this.adjustmentType = builder.adjustmentType;
        this.minAdjustmentStep = builder.minAdjustmentStep;
        this.minAdjustmentMagnitude = builder.minAdjustmentMagnitude;
        this.scalingAdjustment = builder.scalingAdjustment;
        this.cooldown = builder.cooldown;
        this.stepAdjustments = builder.stepAdjustments;
        this.metricAggregationType = builder.metricAggregationType;
        this.estimatedInstanceWarmup = builder.estimatedInstanceWarmup;
        this.alarms = builder.alarms;
    }

    /**
     * <p>
     * The name of the Auto Scaling group associated with this scaling policy.
     * </p>
     * 
     * @return The name of the Auto Scaling group associated with this scaling policy.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The name of the scaling policy.
     * </p>
     * 
     * @return The name of the scaling policy.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the policy.
     */
    public String policyARN() {
        return policyARN;
    }

    /**
     * <p>
     * The policy type. Valid values are <code>SimpleScaling</code> and <code>StepScaling</code>.
     * </p>
     * 
     * @return The policy type. Valid values are <code>SimpleScaling</code> and <code>StepScaling</code>.
     */
    public String policyType() {
        return policyType;
    }

    /**
     * <p>
     * The adjustment type, which specifies how <code>ScalingAdjustment</code> is interpreted. Valid values are
     * <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.
     * </p>
     * 
     * @return The adjustment type, which specifies how <code>ScalingAdjustment</code> is interpreted. Valid values are
     *         <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.
     */
    public String adjustmentType() {
        return adjustmentType;
    }

    /**
     * <p>
     * Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.
     * </p>
     * 
     * @return Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.
     */
    public Integer minAdjustmentStep() {
        return minAdjustmentStep;
    }

    /**
     * <p>
     * The minimum number of instances to scale. If the value of <code>AdjustmentType</code> is
     * <code>PercentChangeInCapacity</code>, the scaling policy changes the <code>DesiredCapacity</code> of the Auto
     * Scaling group by at least this many instances. Otherwise, the error is <code>ValidationError</code>.
     * </p>
     * 
     * @return The minimum number of instances to scale. If the value of <code>AdjustmentType</code> is
     *         <code>PercentChangeInCapacity</code>, the scaling policy changes the <code>DesiredCapacity</code> of the
     *         Auto Scaling group by at least this many instances. Otherwise, the error is <code>ValidationError</code>.
     */
    public Integer minAdjustmentMagnitude() {
        return minAdjustmentMagnitude;
    }

    /**
     * <p>
     * The amount by which to scale, based on the specified adjustment type. A positive value adds to the current
     * capacity while a negative number removes from the current capacity.
     * </p>
     * 
     * @return The amount by which to scale, based on the specified adjustment type. A positive value adds to the
     *         current capacity while a negative number removes from the current capacity.
     */
    public Integer scalingAdjustment() {
        return scalingAdjustment;
    }

    /**
     * <p>
     * The amount of time, in seconds, after a scaling activity completes before any further dynamic scaling activities
     * can start.
     * </p>
     * 
     * @return The amount of time, in seconds, after a scaling activity completes before any further dynamic scaling
     *         activities can start.
     */
    public Integer cooldown() {
        return cooldown;
    }

    /**
     * <p>
     * A set of adjustments that enable you to scale based on the size of the alarm breach.
     * </p>
     * 
     * @return A set of adjustments that enable you to scale based on the size of the alarm breach.
     */
    public List<StepAdjustment> stepAdjustments() {
        return stepAdjustments;
    }

    /**
     * <p>
     * The aggregation type for the CloudWatch metrics. Valid values are <code>Minimum</code>, <code>Maximum</code>, and
     * <code>Average</code>.
     * </p>
     * 
     * @return The aggregation type for the CloudWatch metrics. Valid values are <code>Minimum</code>,
     *         <code>Maximum</code>, and <code>Average</code>.
     */
    public String metricAggregationType() {
        return metricAggregationType;
    }

    /**
     * <p>
     * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
     * </p>
     * 
     * @return The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
     */
    public Integer estimatedInstanceWarmup() {
        return estimatedInstanceWarmup;
    }

    /**
     * <p>
     * The CloudWatch alarms related to the policy.
     * </p>
     * 
     * @return The CloudWatch alarms related to the policy.
     */
    public List<Alarm> alarms() {
        return alarms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((autoScalingGroupName() == null) ? 0 : autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + ((policyName() == null) ? 0 : policyName().hashCode());
        hashCode = 31 * hashCode + ((policyARN() == null) ? 0 : policyARN().hashCode());
        hashCode = 31 * hashCode + ((policyType() == null) ? 0 : policyType().hashCode());
        hashCode = 31 * hashCode + ((adjustmentType() == null) ? 0 : adjustmentType().hashCode());
        hashCode = 31 * hashCode + ((minAdjustmentStep() == null) ? 0 : minAdjustmentStep().hashCode());
        hashCode = 31 * hashCode + ((minAdjustmentMagnitude() == null) ? 0 : minAdjustmentMagnitude().hashCode());
        hashCode = 31 * hashCode + ((scalingAdjustment() == null) ? 0 : scalingAdjustment().hashCode());
        hashCode = 31 * hashCode + ((cooldown() == null) ? 0 : cooldown().hashCode());
        hashCode = 31 * hashCode + ((stepAdjustments() == null) ? 0 : stepAdjustments().hashCode());
        hashCode = 31 * hashCode + ((metricAggregationType() == null) ? 0 : metricAggregationType().hashCode());
        hashCode = 31 * hashCode + ((estimatedInstanceWarmup() == null) ? 0 : estimatedInstanceWarmup().hashCode());
        hashCode = 31 * hashCode + ((alarms() == null) ? 0 : alarms().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingPolicy)) {
            return false;
        }
        ScalingPolicy other = (ScalingPolicy) obj;
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.policyName() == null ^ this.policyName() == null) {
            return false;
        }
        if (other.policyName() != null && !other.policyName().equals(this.policyName())) {
            return false;
        }
        if (other.policyARN() == null ^ this.policyARN() == null) {
            return false;
        }
        if (other.policyARN() != null && !other.policyARN().equals(this.policyARN())) {
            return false;
        }
        if (other.policyType() == null ^ this.policyType() == null) {
            return false;
        }
        if (other.policyType() != null && !other.policyType().equals(this.policyType())) {
            return false;
        }
        if (other.adjustmentType() == null ^ this.adjustmentType() == null) {
            return false;
        }
        if (other.adjustmentType() != null && !other.adjustmentType().equals(this.adjustmentType())) {
            return false;
        }
        if (other.minAdjustmentStep() == null ^ this.minAdjustmentStep() == null) {
            return false;
        }
        if (other.minAdjustmentStep() != null && !other.minAdjustmentStep().equals(this.minAdjustmentStep())) {
            return false;
        }
        if (other.minAdjustmentMagnitude() == null ^ this.minAdjustmentMagnitude() == null) {
            return false;
        }
        if (other.minAdjustmentMagnitude() != null && !other.minAdjustmentMagnitude().equals(this.minAdjustmentMagnitude())) {
            return false;
        }
        if (other.scalingAdjustment() == null ^ this.scalingAdjustment() == null) {
            return false;
        }
        if (other.scalingAdjustment() != null && !other.scalingAdjustment().equals(this.scalingAdjustment())) {
            return false;
        }
        if (other.cooldown() == null ^ this.cooldown() == null) {
            return false;
        }
        if (other.cooldown() != null && !other.cooldown().equals(this.cooldown())) {
            return false;
        }
        if (other.stepAdjustments() == null ^ this.stepAdjustments() == null) {
            return false;
        }
        if (other.stepAdjustments() != null && !other.stepAdjustments().equals(this.stepAdjustments())) {
            return false;
        }
        if (other.metricAggregationType() == null ^ this.metricAggregationType() == null) {
            return false;
        }
        if (other.metricAggregationType() != null && !other.metricAggregationType().equals(this.metricAggregationType())) {
            return false;
        }
        if (other.estimatedInstanceWarmup() == null ^ this.estimatedInstanceWarmup() == null) {
            return false;
        }
        if (other.estimatedInstanceWarmup() != null && !other.estimatedInstanceWarmup().equals(this.estimatedInstanceWarmup())) {
            return false;
        }
        if (other.alarms() == null ^ this.alarms() == null) {
            return false;
        }
        if (other.alarms() != null && !other.alarms().equals(this.alarms())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (policyName() != null) {
            sb.append("PolicyName: ").append(policyName()).append(",");
        }
        if (policyARN() != null) {
            sb.append("PolicyARN: ").append(policyARN()).append(",");
        }
        if (policyType() != null) {
            sb.append("PolicyType: ").append(policyType()).append(",");
        }
        if (adjustmentType() != null) {
            sb.append("AdjustmentType: ").append(adjustmentType()).append(",");
        }
        if (minAdjustmentStep() != null) {
            sb.append("MinAdjustmentStep: ").append(minAdjustmentStep()).append(",");
        }
        if (minAdjustmentMagnitude() != null) {
            sb.append("MinAdjustmentMagnitude: ").append(minAdjustmentMagnitude()).append(",");
        }
        if (scalingAdjustment() != null) {
            sb.append("ScalingAdjustment: ").append(scalingAdjustment()).append(",");
        }
        if (cooldown() != null) {
            sb.append("Cooldown: ").append(cooldown()).append(",");
        }
        if (stepAdjustments() != null) {
            sb.append("StepAdjustments: ").append(stepAdjustments()).append(",");
        }
        if (metricAggregationType() != null) {
            sb.append("MetricAggregationType: ").append(metricAggregationType()).append(",");
        }
        if (estimatedInstanceWarmup() != null) {
            sb.append("EstimatedInstanceWarmup: ").append(estimatedInstanceWarmup()).append(",");
        }
        if (alarms() != null) {
            sb.append("Alarms: ").append(alarms()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ScalingPolicy> {
        /**
         * <p>
         * The name of the Auto Scaling group associated with this scaling policy.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group associated with this scaling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The name of the scaling policy.
         * </p>
         * 
         * @param policyName
         *        The name of the scaling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the policy.
         * </p>
         * 
         * @param policyARN
         *        The Amazon Resource Name (ARN) of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyARN(String policyARN);

        /**
         * <p>
         * The policy type. Valid values are <code>SimpleScaling</code> and <code>StepScaling</code>.
         * </p>
         * 
         * @param policyType
         *        The policy type. Valid values are <code>SimpleScaling</code> and <code>StepScaling</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * The adjustment type, which specifies how <code>ScalingAdjustment</code> is interpreted. Valid values are
         * <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and <code>PercentChangeInCapacity</code>.
         * </p>
         * 
         * @param adjustmentType
         *        The adjustment type, which specifies how <code>ScalingAdjustment</code> is interpreted. Valid values
         *        are <code>ChangeInCapacity</code>, <code>ExactCapacity</code>, and
         *        <code>PercentChangeInCapacity</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adjustmentType(String adjustmentType);

        /**
         * <p>
         * Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.
         * </p>
         * 
         * @param minAdjustmentStep
         *        Available for backward compatibility. Use <code>MinAdjustmentMagnitude</code> instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minAdjustmentStep(Integer minAdjustmentStep);

        /**
         * <p>
         * The minimum number of instances to scale. If the value of <code>AdjustmentType</code> is
         * <code>PercentChangeInCapacity</code>, the scaling policy changes the <code>DesiredCapacity</code> of the Auto
         * Scaling group by at least this many instances. Otherwise, the error is <code>ValidationError</code>.
         * </p>
         * 
         * @param minAdjustmentMagnitude
         *        The minimum number of instances to scale. If the value of <code>AdjustmentType</code> is
         *        <code>PercentChangeInCapacity</code>, the scaling policy changes the <code>DesiredCapacity</code> of
         *        the Auto Scaling group by at least this many instances. Otherwise, the error is
         *        <code>ValidationError</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minAdjustmentMagnitude(Integer minAdjustmentMagnitude);

        /**
         * <p>
         * The amount by which to scale, based on the specified adjustment type. A positive value adds to the current
         * capacity while a negative number removes from the current capacity.
         * </p>
         * 
         * @param scalingAdjustment
         *        The amount by which to scale, based on the specified adjustment type. A positive value adds to the
         *        current capacity while a negative number removes from the current capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingAdjustment(Integer scalingAdjustment);

        /**
         * <p>
         * The amount of time, in seconds, after a scaling activity completes before any further dynamic scaling
         * activities can start.
         * </p>
         * 
         * @param cooldown
         *        The amount of time, in seconds, after a scaling activity completes before any further dynamic scaling
         *        activities can start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cooldown(Integer cooldown);

        /**
         * <p>
         * A set of adjustments that enable you to scale based on the size of the alarm breach.
         * </p>
         * 
         * @param stepAdjustments
         *        A set of adjustments that enable you to scale based on the size of the alarm breach.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepAdjustments(Collection<StepAdjustment> stepAdjustments);

        /**
         * <p>
         * A set of adjustments that enable you to scale based on the size of the alarm breach.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setStepAdjustments(java.util.Collection)} or {@link #withStepAdjustments(java.util.Collection)} if
         * you want to override the existing values.
         * </p>
         * 
         * @param stepAdjustments
         *        A set of adjustments that enable you to scale based on the size of the alarm breach.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepAdjustments(StepAdjustment... stepAdjustments);

        /**
         * <p>
         * The aggregation type for the CloudWatch metrics. Valid values are <code>Minimum</code>, <code>Maximum</code>,
         * and <code>Average</code>.
         * </p>
         * 
         * @param metricAggregationType
         *        The aggregation type for the CloudWatch metrics. Valid values are <code>Minimum</code>,
         *        <code>Maximum</code>, and <code>Average</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricAggregationType(String metricAggregationType);

        /**
         * <p>
         * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
         * </p>
         * 
         * @param estimatedInstanceWarmup
         *        The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch
         *        metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedInstanceWarmup(Integer estimatedInstanceWarmup);

        /**
         * <p>
         * The CloudWatch alarms related to the policy.
         * </p>
         * 
         * @param alarms
         *        The CloudWatch alarms related to the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarms(Collection<Alarm> alarms);

        /**
         * <p>
         * The CloudWatch alarms related to the policy.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setAlarms(java.util.Collection)} or {@link #withAlarms(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param alarms
         *        The CloudWatch alarms related to the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarms(Alarm... alarms);
    }

    private static final class BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String policyName;

        private String policyARN;

        private String policyType;

        private String adjustmentType;

        private Integer minAdjustmentStep;

        private Integer minAdjustmentMagnitude;

        private Integer scalingAdjustment;

        private Integer cooldown;

        private List<StepAdjustment> stepAdjustments = new SdkInternalList<>();

        private String metricAggregationType;

        private Integer estimatedInstanceWarmup;

        private List<Alarm> alarms = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingPolicy model) {
            setAutoScalingGroupName(model.autoScalingGroupName);
            setPolicyName(model.policyName);
            setPolicyARN(model.policyARN);
            setPolicyType(model.policyType);
            setAdjustmentType(model.adjustmentType);
            setMinAdjustmentStep(model.minAdjustmentStep);
            setMinAdjustmentMagnitude(model.minAdjustmentMagnitude);
            setScalingAdjustment(model.scalingAdjustment);
            setCooldown(model.cooldown);
            setStepAdjustments(model.stepAdjustments);
            setMetricAggregationType(model.metricAggregationType);
            setEstimatedInstanceWarmup(model.estimatedInstanceWarmup);
            setAlarms(model.alarms);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyARN() {
            return policyARN;
        }

        @Override
        public final Builder policyARN(String policyARN) {
            this.policyARN = policyARN;
            return this;
        }

        public final void setPolicyARN(String policyARN) {
            this.policyARN = policyARN;
        }

        public final String getPolicyType() {
            return policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        public final String getAdjustmentType() {
            return adjustmentType;
        }

        @Override
        public final Builder adjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        public final void setAdjustmentType(String adjustmentType) {
            this.adjustmentType = adjustmentType;
        }

        public final Integer getMinAdjustmentStep() {
            return minAdjustmentStep;
        }

        @Override
        public final Builder minAdjustmentStep(Integer minAdjustmentStep) {
            this.minAdjustmentStep = minAdjustmentStep;
            return this;
        }

        public final void setMinAdjustmentStep(Integer minAdjustmentStep) {
            this.minAdjustmentStep = minAdjustmentStep;
        }

        public final Integer getMinAdjustmentMagnitude() {
            return minAdjustmentMagnitude;
        }

        @Override
        public final Builder minAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
            return this;
        }

        public final void setMinAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
        }

        public final Integer getScalingAdjustment() {
            return scalingAdjustment;
        }

        @Override
        public final Builder scalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        public final void setScalingAdjustment(Integer scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
        }

        public final Integer getCooldown() {
            return cooldown;
        }

        @Override
        public final Builder cooldown(Integer cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public final void setCooldown(Integer cooldown) {
            this.cooldown = cooldown;
        }

        public final Collection<StepAdjustment> getStepAdjustments() {
            return stepAdjustments;
        }

        @Override
        public final Builder stepAdjustments(Collection<StepAdjustment> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copy(stepAdjustments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepAdjustments(StepAdjustment... stepAdjustments) {
            if (this.stepAdjustments == null) {
                this.stepAdjustments = new SdkInternalList<>(stepAdjustments.length);
            }
            for (StepAdjustment e : stepAdjustments) {
                this.stepAdjustments.add(e);
            }
            return this;
        }

        public final void setStepAdjustments(Collection<StepAdjustment> stepAdjustments) {
            this.stepAdjustments = StepAdjustmentsCopier.copy(stepAdjustments);
        }

        @SafeVarargs
        public final void setStepAdjustments(StepAdjustment... stepAdjustments) {
            if (this.stepAdjustments == null) {
                this.stepAdjustments = new SdkInternalList<>(stepAdjustments.length);
            }
            for (StepAdjustment e : stepAdjustments) {
                this.stepAdjustments.add(e);
            }
        }

        public final String getMetricAggregationType() {
            return metricAggregationType;
        }

        @Override
        public final Builder metricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
            return this;
        }

        public final void setMetricAggregationType(String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
        }

        public final Integer getEstimatedInstanceWarmup() {
            return estimatedInstanceWarmup;
        }

        @Override
        public final Builder estimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
            return this;
        }

        public final void setEstimatedInstanceWarmup(Integer estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
        }

        public final Collection<Alarm> getAlarms() {
            return alarms;
        }

        @Override
        public final Builder alarms(Collection<Alarm> alarms) {
            this.alarms = AlarmsCopier.copy(alarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarms(Alarm... alarms) {
            if (this.alarms == null) {
                this.alarms = new SdkInternalList<>(alarms.length);
            }
            for (Alarm e : alarms) {
                this.alarms.add(e);
            }
            return this;
        }

        public final void setAlarms(Collection<Alarm> alarms) {
            this.alarms = AlarmsCopier.copy(alarms);
        }

        @SafeVarargs
        public final void setAlarms(Alarm... alarms) {
            if (this.alarms == null) {
                this.alarms = new SdkInternalList<>(alarms.length);
            }
            for (Alarm e : alarms) {
                this.alarms.add(e);
            }
        }

        @Override
        public ScalingPolicy build() {
            return new ScalingPolicy(this);
        }
    }
}
