/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeNotificationConfigurationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeNotificationConfigurationsResponse.Builder, DescribeNotificationConfigurationsResponse> {
    private final List<NotificationConfiguration> notificationConfigurations;

    private final String nextToken;

    private DescribeNotificationConfigurationsResponse(BuilderImpl builder) {
        this.notificationConfigurations = builder.notificationConfigurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The notification configurations.
     * </p>
     * 
     * @return The notification configurations.
     */
    public List<NotificationConfiguration> notificationConfigurations() {
        return notificationConfigurations;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((notificationConfigurations() == null) ? 0 : notificationConfigurations().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotificationConfigurationsResponse)) {
            return false;
        }
        DescribeNotificationConfigurationsResponse other = (DescribeNotificationConfigurationsResponse) obj;
        if (other.notificationConfigurations() == null ^ this.notificationConfigurations() == null) {
            return false;
        }
        if (other.notificationConfigurations() != null
                && !other.notificationConfigurations().equals(this.notificationConfigurations())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (notificationConfigurations() != null) {
            sb.append("NotificationConfigurations: ").append(notificationConfigurations()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeNotificationConfigurationsResponse> {
        /**
         * <p>
         * The notification configurations.
         * </p>
         * 
         * @param notificationConfigurations
         *        The notification configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfigurations(Collection<NotificationConfiguration> notificationConfigurations);

        /**
         * <p>
         * The notification configurations.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setNotificationConfigurations(java.util.Collection)} or
         * {@link #withNotificationConfigurations(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param notificationConfigurations
         *        The notification configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfigurations(NotificationConfiguration... notificationConfigurations);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<NotificationConfiguration> notificationConfigurations = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotificationConfigurationsResponse model) {
            setNotificationConfigurations(model.notificationConfigurations);
            setNextToken(model.nextToken);
        }

        public final Collection<NotificationConfiguration> getNotificationConfigurations() {
            return notificationConfigurations;
        }

        @Override
        public final Builder notificationConfigurations(Collection<NotificationConfiguration> notificationConfigurations) {
            this.notificationConfigurations = NotificationConfigurationsCopier.copy(notificationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationConfigurations(NotificationConfiguration... notificationConfigurations) {
            if (this.notificationConfigurations == null) {
                this.notificationConfigurations = new SdkInternalList<>(notificationConfigurations.length);
            }
            for (NotificationConfiguration e : notificationConfigurations) {
                this.notificationConfigurations.add(e);
            }
            return this;
        }

        public final void setNotificationConfigurations(Collection<NotificationConfiguration> notificationConfigurations) {
            this.notificationConfigurations = NotificationConfigurationsCopier.copy(notificationConfigurations);
        }

        @SafeVarargs
        public final void setNotificationConfigurations(NotificationConfiguration... notificationConfigurations) {
            if (this.notificationConfigurations == null) {
                this.notificationConfigurations = new SdkInternalList<>(notificationConfigurations.length);
            }
            for (NotificationConfiguration e : notificationConfigurations) {
                this.notificationConfigurations.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeNotificationConfigurationsResponse build() {
            return new DescribeNotificationConfigurationsResponse(this);
        }
    }
}
