/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeLifecycleHooksResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeLifecycleHooksResponse.Builder, DescribeLifecycleHooksResponse> {
    private final List<LifecycleHook> lifecycleHooks;

    private DescribeLifecycleHooksResponse(BuilderImpl builder) {
        this.lifecycleHooks = builder.lifecycleHooks;
    }

    /**
     * <p>
     * The lifecycle hooks for the specified group.
     * </p>
     * 
     * @return The lifecycle hooks for the specified group.
     */
    public List<LifecycleHook> lifecycleHooks() {
        return lifecycleHooks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((lifecycleHooks() == null) ? 0 : lifecycleHooks().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLifecycleHooksResponse)) {
            return false;
        }
        DescribeLifecycleHooksResponse other = (DescribeLifecycleHooksResponse) obj;
        if (other.lifecycleHooks() == null ^ this.lifecycleHooks() == null) {
            return false;
        }
        if (other.lifecycleHooks() != null && !other.lifecycleHooks().equals(this.lifecycleHooks())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (lifecycleHooks() != null) {
            sb.append("LifecycleHooks: ").append(lifecycleHooks()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeLifecycleHooksResponse> {
        /**
         * <p>
         * The lifecycle hooks for the specified group.
         * </p>
         * 
         * @param lifecycleHooks
         *        The lifecycle hooks for the specified group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHooks(Collection<LifecycleHook> lifecycleHooks);

        /**
         * <p>
         * The lifecycle hooks for the specified group.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setLifecycleHooks(java.util.Collection)} or {@link #withLifecycleHooks(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param lifecycleHooks
         *        The lifecycle hooks for the specified group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHooks(LifecycleHook... lifecycleHooks);
    }

    private static final class BuilderImpl implements Builder {
        private List<LifecycleHook> lifecycleHooks = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLifecycleHooksResponse model) {
            setLifecycleHooks(model.lifecycleHooks);
        }

        public final Collection<LifecycleHook> getLifecycleHooks() {
            return lifecycleHooks;
        }

        @Override
        public final Builder lifecycleHooks(Collection<LifecycleHook> lifecycleHooks) {
            this.lifecycleHooks = LifecycleHooksCopier.copy(lifecycleHooks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHooks(LifecycleHook... lifecycleHooks) {
            if (this.lifecycleHooks == null) {
                this.lifecycleHooks = new SdkInternalList<>(lifecycleHooks.length);
            }
            for (LifecycleHook e : lifecycleHooks) {
                this.lifecycleHooks.add(e);
            }
            return this;
        }

        public final void setLifecycleHooks(Collection<LifecycleHook> lifecycleHooks) {
            this.lifecycleHooks = LifecycleHooksCopier.copy(lifecycleHooks);
        }

        @SafeVarargs
        public final void setLifecycleHooks(LifecycleHook... lifecycleHooks) {
            if (this.lifecycleHooks == null) {
                this.lifecycleHooks = new SdkInternalList<>(lifecycleHooks.length);
            }
            for (LifecycleHook e : lifecycleHooks) {
                this.lifecycleHooks.add(e);
            }
        }

        @Override
        public DescribeLifecycleHooksResponse build() {
            return new DescribeLifecycleHooksResponse(this);
        }
    }
}
