/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeLifecycleHooksRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeLifecycleHooksRequest.Builder, DescribeLifecycleHooksRequest> {
    private final String autoScalingGroupName;

    private final List<String> lifecycleHookNames;

    private DescribeLifecycleHooksRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.lifecycleHookNames = builder.lifecycleHookNames;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The names of one or more lifecycle hooks. If you omit this parameter, all lifecycle hooks are described.
     * </p>
     * 
     * @return The names of one or more lifecycle hooks. If you omit this parameter, all lifecycle hooks are described.
     */
    public List<String> lifecycleHookNames() {
        return lifecycleHookNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((autoScalingGroupName() == null) ? 0 : autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + ((lifecycleHookNames() == null) ? 0 : lifecycleHookNames().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLifecycleHooksRequest)) {
            return false;
        }
        DescribeLifecycleHooksRequest other = (DescribeLifecycleHooksRequest) obj;
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.lifecycleHookNames() == null ^ this.lifecycleHookNames() == null) {
            return false;
        }
        if (other.lifecycleHookNames() != null && !other.lifecycleHookNames().equals(this.lifecycleHookNames())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (lifecycleHookNames() != null) {
            sb.append("LifecycleHookNames: ").append(lifecycleHookNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeLifecycleHooksRequest> {
        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The names of one or more lifecycle hooks. If you omit this parameter, all lifecycle hooks are described.
         * </p>
         * 
         * @param lifecycleHookNames
         *        The names of one or more lifecycle hooks. If you omit this parameter, all lifecycle hooks are
         *        described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHookNames(Collection<String> lifecycleHookNames);

        /**
         * <p>
         * The names of one or more lifecycle hooks. If you omit this parameter, all lifecycle hooks are described.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setLifecycleHookNames(java.util.Collection)} or {@link #withLifecycleHookNames(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param lifecycleHookNames
         *        The names of one or more lifecycle hooks. If you omit this parameter, all lifecycle hooks are
         *        described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHookNames(String... lifecycleHookNames);
    }

    private static final class BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private List<String> lifecycleHookNames = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLifecycleHooksRequest model) {
            setAutoScalingGroupName(model.autoScalingGroupName);
            setLifecycleHookNames(model.lifecycleHookNames);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getLifecycleHookNames() {
            return lifecycleHookNames;
        }

        @Override
        public final Builder lifecycleHookNames(Collection<String> lifecycleHookNames) {
            this.lifecycleHookNames = LifecycleHookNamesCopier.copy(lifecycleHookNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHookNames(String... lifecycleHookNames) {
            if (this.lifecycleHookNames == null) {
                this.lifecycleHookNames = new SdkInternalList<>(lifecycleHookNames.length);
            }
            for (String e : lifecycleHookNames) {
                this.lifecycleHookNames.add(e);
            }
            return this;
        }

        public final void setLifecycleHookNames(Collection<String> lifecycleHookNames) {
            this.lifecycleHookNames = LifecycleHookNamesCopier.copy(lifecycleHookNames);
        }

        @SafeVarargs
        public final void setLifecycleHookNames(String... lifecycleHookNames) {
            if (this.lifecycleHookNames == null) {
                this.lifecycleHookNames = new SdkInternalList<>(lifecycleHookNames.length);
            }
            for (String e : lifecycleHookNames) {
                this.lifecycleHookNames.add(e);
            }
        }

        @Override
        public DescribeLifecycleHooksRequest build() {
            return new DescribeLifecycleHooksRequest(this);
        }
    }
}
