/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an EC2 instance associated with an Auto Scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AutoScalingInstanceDetails implements
        ToCopyableBuilder<AutoScalingInstanceDetails.Builder, AutoScalingInstanceDetails> {
    private final String instanceId;

    private final String autoScalingGroupName;

    private final String availabilityZone;

    private final String lifecycleState;

    private final String healthStatus;

    private final String launchConfigurationName;

    private final Boolean protectedFromScaleIn;

    private AutoScalingInstanceDetails(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.availabilityZone = builder.availabilityZone;
        this.lifecycleState = builder.lifecycleState;
        this.healthStatus = builder.healthStatus;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.protectedFromScaleIn = builder.protectedFromScaleIn;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The name of the Auto Scaling group associated with the instance.
     * </p>
     * 
     * @return The name of the Auto Scaling group associated with the instance.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The Availability Zone for the instance.
     * </p>
     * 
     * @return The Availability Zone for the instance.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The lifecycle state for the instance. For more information, see <a
     * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/AutoScalingGroupLifecycle.html">Auto Scaling
     * Lifecycle</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return The lifecycle state for the instance. For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/AutoScalingGroupLifecycle.html">Auto
     *         Scaling Lifecycle</a> in the <i>Auto Scaling User Guide</i>.
     */
    public String lifecycleState() {
        return lifecycleState;
    }

    /**
     * <p>
     * The last reported health status of this instance. "Healthy" means that the instance is healthy and should remain
     * in service. "Unhealthy" means that the instance is unhealthy and Auto Scaling should terminate and replace it.
     * </p>
     * 
     * @return The last reported health status of this instance. "Healthy" means that the instance is healthy and should
     *         remain in service. "Unhealthy" means that the instance is unhealthy and Auto Scaling should terminate and
     *         replace it.
     */
    public String healthStatus() {
        return healthStatus;
    }

    /**
     * <p>
     * The launch configuration used to launch the instance. This value is not available if you attached the instance to
     * the Auto Scaling group.
     * </p>
     * 
     * @return The launch configuration used to launch the instance. This value is not available if you attached the
     *         instance to the Auto Scaling group.
     */
    public String launchConfigurationName() {
        return launchConfigurationName;
    }

    /**
     * <p>
     * Indicates whether the instance is protected from termination by Auto Scaling when scaling in.
     * </p>
     * 
     * @return Indicates whether the instance is protected from termination by Auto Scaling when scaling in.
     */
    public Boolean protectedFromScaleIn() {
        return protectedFromScaleIn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((autoScalingGroupName() == null) ? 0 : autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((lifecycleState() == null) ? 0 : lifecycleState().hashCode());
        hashCode = 31 * hashCode + ((healthStatus() == null) ? 0 : healthStatus().hashCode());
        hashCode = 31 * hashCode + ((launchConfigurationName() == null) ? 0 : launchConfigurationName().hashCode());
        hashCode = 31 * hashCode + ((protectedFromScaleIn() == null) ? 0 : protectedFromScaleIn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingInstanceDetails)) {
            return false;
        }
        AutoScalingInstanceDetails other = (AutoScalingInstanceDetails) obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.lifecycleState() == null ^ this.lifecycleState() == null) {
            return false;
        }
        if (other.lifecycleState() != null && !other.lifecycleState().equals(this.lifecycleState())) {
            return false;
        }
        if (other.healthStatus() == null ^ this.healthStatus() == null) {
            return false;
        }
        if (other.healthStatus() != null && !other.healthStatus().equals(this.healthStatus())) {
            return false;
        }
        if (other.launchConfigurationName() == null ^ this.launchConfigurationName() == null) {
            return false;
        }
        if (other.launchConfigurationName() != null && !other.launchConfigurationName().equals(this.launchConfigurationName())) {
            return false;
        }
        if (other.protectedFromScaleIn() == null ^ this.protectedFromScaleIn() == null) {
            return false;
        }
        if (other.protectedFromScaleIn() != null && !other.protectedFromScaleIn().equals(this.protectedFromScaleIn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (lifecycleState() != null) {
            sb.append("LifecycleState: ").append(lifecycleState()).append(",");
        }
        if (healthStatus() != null) {
            sb.append("HealthStatus: ").append(healthStatus()).append(",");
        }
        if (launchConfigurationName() != null) {
            sb.append("LaunchConfigurationName: ").append(launchConfigurationName()).append(",");
        }
        if (protectedFromScaleIn() != null) {
            sb.append("ProtectedFromScaleIn: ").append(protectedFromScaleIn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AutoScalingInstanceDetails> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The name of the Auto Scaling group associated with the instance.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The Availability Zone for the instance.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The lifecycle state for the instance. For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/AutoScalingGroupLifecycle.html">Auto Scaling
         * Lifecycle</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param lifecycleState
         *        The lifecycle state for the instance. For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/AutoScalingGroupLifecycle.html">Auto
         *        Scaling Lifecycle</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleState(String lifecycleState);

        /**
         * <p>
         * The last reported health status of this instance. "Healthy" means that the instance is healthy and should
         * remain in service. "Unhealthy" means that the instance is unhealthy and Auto Scaling should terminate and
         * replace it.
         * </p>
         * 
         * @param healthStatus
         *        The last reported health status of this instance. "Healthy" means that the instance is healthy and
         *        should remain in service. "Unhealthy" means that the instance is unhealthy and Auto Scaling should
         *        terminate and replace it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthStatus(String healthStatus);

        /**
         * <p>
         * The launch configuration used to launch the instance. This value is not available if you attached the
         * instance to the Auto Scaling group.
         * </p>
         * 
         * @param launchConfigurationName
         *        The launch configuration used to launch the instance. This value is not available if you attached the
         *        instance to the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationName(String launchConfigurationName);

        /**
         * <p>
         * Indicates whether the instance is protected from termination by Auto Scaling when scaling in.
         * </p>
         * 
         * @param protectedFromScaleIn
         *        Indicates whether the instance is protected from termination by Auto Scaling when scaling in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedFromScaleIn(Boolean protectedFromScaleIn);
    }

    private static final class BuilderImpl implements Builder {
        private String instanceId;

        private String autoScalingGroupName;

        private String availabilityZone;

        private String lifecycleState;

        private String healthStatus;

        private String launchConfigurationName;

        private Boolean protectedFromScaleIn;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingInstanceDetails model) {
            setInstanceId(model.instanceId);
            setAutoScalingGroupName(model.autoScalingGroupName);
            setAvailabilityZone(model.availabilityZone);
            setLifecycleState(model.lifecycleState);
            setHealthStatus(model.healthStatus);
            setLaunchConfigurationName(model.launchConfigurationName);
            setProtectedFromScaleIn(model.protectedFromScaleIn);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getLifecycleState() {
            return lifecycleState;
        }

        @Override
        public final Builder lifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public final void setLifecycleState(String lifecycleState) {
            this.lifecycleState = lifecycleState;
        }

        public final String getHealthStatus() {
            return healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        public final String getLaunchConfigurationName() {
            return launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final Boolean getProtectedFromScaleIn() {
            return protectedFromScaleIn;
        }

        @Override
        public final Builder protectedFromScaleIn(Boolean protectedFromScaleIn) {
            this.protectedFromScaleIn = protectedFromScaleIn;
            return this;
        }

        public final void setProtectedFromScaleIn(Boolean protectedFromScaleIn) {
            this.protectedFromScaleIn = protectedFromScaleIn;
        }

        @Override
        public AutoScalingInstanceDetails build() {
            return new AutoScalingInstanceDetails(this);
        }
    }
}
