/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.ChildProfileCredentialsProviderFactory;
import software.amazon.awssdk.auth.credentials.ProcessCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.profiles.Profile;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class ProfileCredentialsUtils {
    private static final String STS_PROFILE_CREDENTIALS_PROVIDER_FACTORY = "software.amazon.awssdk.services.sts.internal.StsProfileCredentialsProviderFactory";
    private final Profile profile;
    private final String name;
    private final Map<String, String> properties;
    private final Function<String, Optional<Profile>> credentialsSourceResolver;

    public ProfileCredentialsUtils(Profile profile, Function<String, Optional<Profile>> credentialsSourceResolver) {
        this.profile = (Profile)Validate.paramNotNull((Object)profile, (String)"profile");
        this.name = profile.name();
        this.properties = profile.properties();
        this.credentialsSourceResolver = credentialsSourceResolver;
    }

    public Optional<AwsCredentialsProvider> credentialsProvider() {
        return this.credentialsProvider(new HashSet<String>());
    }

    private Optional<AwsCredentialsProvider> credentialsProvider(Set<String> children) {
        if (this.properties.containsKey("role_arn")) {
            return Optional.ofNullable(this.roleBasedProfileCredentialsProvider(children));
        }
        if (this.properties.containsKey("credential_process")) {
            return Optional.ofNullable(this.credentialProcessCredentialsProvider());
        }
        if (this.properties.containsKey("aws_session_token")) {
            return Optional.of(this.sessionProfileCredentialsProvider());
        }
        if (this.properties.containsKey("aws_access_key_id")) {
            return Optional.of(this.basicProfileCredentialsProvider());
        }
        return Optional.empty();
    }

    private AwsCredentialsProvider basicProfileCredentialsProvider() {
        this.requireProperties("aws_access_key_id", "aws_secret_access_key");
        AwsBasicCredentials credentials = AwsBasicCredentials.create(this.properties.get("aws_access_key_id"), this.properties.get("aws_secret_access_key"));
        return StaticCredentialsProvider.create(credentials);
    }

    private AwsCredentialsProvider sessionProfileCredentialsProvider() {
        this.requireProperties("aws_access_key_id", "aws_secret_access_key", "aws_session_token");
        AwsSessionCredentials credentials = AwsSessionCredentials.create(this.properties.get("aws_access_key_id"), this.properties.get("aws_secret_access_key"), this.properties.get("aws_session_token"));
        return StaticCredentialsProvider.create(credentials);
    }

    private AwsCredentialsProvider credentialProcessCredentialsProvider() {
        this.requireProperties("credential_process");
        return ProcessCredentialsProvider.builder().command(this.properties.get("credential_process")).build();
    }

    private AwsCredentialsProvider roleBasedProfileCredentialsProvider(Set<String> children) {
        this.requireProperties("source_profile");
        Validate.validState((!children.contains(this.name) ? 1 : 0) != 0, (String)"Invalid profile file: Circular relationship detected with profiles %s.", (Object[])new Object[]{children});
        Validate.validState((this.credentialsSourceResolver != null ? 1 : 0) != 0, (String)"The profile '%s' must be configured with a source profile in order to use assumed roles.", (Object[])new Object[]{this.name});
        children.add(this.name);
        AwsCredentialsProvider sourceCredentialsProvider = (AwsCredentialsProvider)this.credentialsSourceResolver.apply(this.properties.get("source_profile")).flatMap(p -> new ProfileCredentialsUtils((Profile)p, this.credentialsSourceResolver).credentialsProvider(children)).orElseThrow(this::noSourceCredentialsException);
        return this.stsCredentialsProviderFactory().create(sourceCredentialsProvider, this.profile);
    }

    private void requireProperties(String ... requiredProperties) {
        Arrays.stream(requiredProperties).forEach(p -> Validate.isTrue((boolean)this.properties.containsKey(p), (String)"Profile property '%s' was not configured for '%s'.", (Object[])new Object[]{p, this.name}));
    }

    private IllegalStateException noSourceCredentialsException() {
        String error = String.format("The source profile of '%s' was configured to be '%s', but that source profile has no credentials configured.", this.name, this.properties.get("source_profile"));
        return new IllegalStateException(error);
    }

    private ChildProfileCredentialsProviderFactory stsCredentialsProviderFactory() {
        try {
            Class<?> stsCredentialsProviderFactory = Class.forName(STS_PROFILE_CREDENTIALS_PROVIDER_FACTORY, true, Thread.currentThread().getContextClassLoader());
            return (ChildProfileCredentialsProviderFactory)stsCredentialsProviderFactory.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("To use assumed roles in the '" + this.name + "' profile, the 'sts' service module must be on the class path.", e);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to create the '" + this.name + "' profile credentials provider.", e);
        }
    }
}

