/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.SystemSetting;

@SdkInternalApi
abstract class SystemSettingsCredentialsProvider
implements AwsCredentialsProvider {
    SystemSettingsCredentialsProvider() {
    }

    @Override
    public AwsCredentials getCredentials() {
        String accessKey = StringUtils.trim((String)this.loadSetting((SystemSetting)SdkSystemSetting.AWS_ACCESS_KEY_ID).orElse(null));
        String secretKey = StringUtils.trim((String)this.loadSetting((SystemSetting)SdkSystemSetting.AWS_SECRET_ACCESS_KEY).orElse(null));
        String sessionToken = StringUtils.trim((String)this.loadSetting((SystemSetting)SdkSystemSetting.AWS_SESSION_TOKEN).orElse(null));
        if (StringUtils.isEmpty((CharSequence)accessKey)) {
            throw new SdkClientException(String.format("Unable to load credentials from system settings. Access key must be specified either via environment variable (%s) or system property (%s).", SdkSystemSetting.AWS_ACCESS_KEY_ID.environmentVariable(), SdkSystemSetting.AWS_ACCESS_KEY_ID.property()));
        }
        if (StringUtils.isEmpty((CharSequence)secretKey)) {
            throw new SdkClientException(String.format("Unable to load credentials from system settings. Secret key must be specified either via environment variable (%s) or system property (%s).", SdkSystemSetting.AWS_SECRET_ACCESS_KEY.environmentVariable(), SdkSystemSetting.AWS_SECRET_ACCESS_KEY.property()));
        }
        return sessionToken == null ? AwsCredentials.create(accessKey, secretKey) : AwsSessionCredentials.create(accessKey, secretKey, sessionToken);
    }

    protected abstract Optional<String> loadSetting(SystemSetting var1);
}

