/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.auth.credentials;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.util.ComparableUtils;
import software.amazon.awssdk.core.util.DateUtils;
import software.amazon.awssdk.core.util.json.JacksonUtils;
import software.amazon.awssdk.regions.util.HttpResourcesUtils;
import software.amazon.awssdk.regions.util.ResourcesEndpointProvider;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.cache.CachedSupplier;
import software.amazon.awssdk.utils.cache.NonBlocking;
import software.amazon.awssdk.utils.cache.RefreshResult;

@SdkInternalApi
abstract class HttpCredentialsProvider
implements AwsCredentialsProvider,
SdkAutoCloseable {
    private final CachedSupplier<AwsCredentials> credentialsCache;

    HttpCredentialsProvider(Builder<?, ?> builder) {
        this(((Builder)builder).asyncCredentialUpdateEnabled, ((Builder)builder).asyncThreadName);
    }

    HttpCredentialsProvider(boolean asyncCredentialUpdateEnabled, String asyncThreadName) {
        CachedSupplier.Builder cacheBuilder = CachedSupplier.builder(this::refreshCredentials);
        if (asyncCredentialUpdateEnabled) {
            cacheBuilder.prefetchStrategy((CachedSupplier.PrefetchStrategy)new NonBlocking(asyncThreadName));
        }
        this.credentialsCache = cacheBuilder.build();
    }

    protected abstract ResourcesEndpointProvider getCredentialsEndpointProvider();

    private RefreshResult<AwsCredentials> refreshCredentials() {
        try {
            String credentialsResponse = HttpResourcesUtils.instance().readResource(this.getCredentialsEndpointProvider());
            JsonNode node = JacksonUtils.jsonNodeOf((String)credentialsResponse);
            JsonNode accessKey = node.get("AccessKeyId");
            JsonNode secretKey = node.get("SecretAccessKey");
            JsonNode token = node.get("Token");
            JsonNode expirationNode = node.get("Expiration");
            Validate.notNull((Object)accessKey, (String)"Failed to load access key.", (Object[])new Object[0]);
            Validate.notNull((Object)secretKey, (String)"Failed to load secret key.", (Object[])new Object[0]);
            AwsCredentials credentials = token == null ? new AwsCredentials(accessKey.asText(), secretKey.asText()) : AwsSessionCredentials.create(accessKey.asText(), secretKey.asText(), token.asText());
            Instant expiration = this.getExpiration(expirationNode).orElse(null);
            if (expiration != null && Instant.now().isAfter(expiration)) {
                throw new SdkClientException("Credentials obtained from metadata service are already expired.");
            }
            return RefreshResult.builder((Object)credentials).staleTime(this.getStaleTime(expiration)).prefetchTime(this.getPrefetchTime(expiration)).build();
        }
        catch (SdkClientException e) {
            throw e;
        }
        catch (JsonMappingException e) {
            throw new SdkClientException("Unable to parse response returned from service endpoint.", (Throwable)e);
        }
        catch (IOException | RuntimeException e) {
            throw new SdkClientException("Unable to load credentials from service endpoint.", (Throwable)e);
        }
    }

    private Optional<Instant> getExpiration(JsonNode expirationNode) {
        return Optional.ofNullable(expirationNode).map(node -> {
            String expirationValue = node.asText().replaceAll("\\+0000$", "Z");
            try {
                return DateUtils.parseIso8601Date((String)expirationValue);
            }
            catch (RuntimeException e) {
                throw new IllegalStateException("Unable to parse credentials expiration date from metadata service.", e);
            }
        });
    }

    private Instant getStaleTime(Instant expiration) {
        return expiration == null ? null : expiration.minus(Duration.ofMinutes(1L));
    }

    private Instant getPrefetchTime(Instant expiration) {
        Instant oneHourFromNow = Instant.now().plus(Duration.ofHours(1L));
        return expiration == null ? oneHourFromNow : (Instant)ComparableUtils.minimum((Comparable[])new Instant[]{oneHourFromNow, expiration.minus(Duration.ofMinutes(15L))});
    }

    @Override
    public AwsCredentials getCredentials() {
        return (AwsCredentials)this.credentialsCache.get();
    }

    public void close() {
        this.credentialsCache.close();
    }

    protected static abstract class Builder<TypeToBuildT extends HttpCredentialsProvider, BuilderT extends Builder> {
        private boolean asyncCredentialUpdateEnabled = false;
        private String asyncThreadName;

        protected Builder() {
        }

        public BuilderT asyncCredentialUpdateEnabled(Boolean asyncCredentialUpdateEnabled) {
            this.asyncCredentialUpdateEnabled = asyncCredentialUpdateEnabled;
            return (BuilderT)this;
        }

        public BuilderT asyncThreadName(String asyncThreadName) {
            this.asyncThreadName = asyncThreadName;
            return (BuilderT)this;
        }

        public abstract TypeToBuildT build();
    }
}

