/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.authcrt.signer.internal.chunkedencoding;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.internal.chunkedencoding.AwsChunkSigner;
import software.amazon.awssdk.authcrt.signer.internal.AwsCrt4aSigningAdapter;
import software.amazon.awssdk.crt.auth.signing.AwsSigningConfig;
import software.amazon.awssdk.crt.auth.signing.AwsSigningResult;
import software.amazon.awssdk.utils.BinaryUtils;

@SdkInternalApi
public class AwsS3V4aChunkSigner
implements AwsChunkSigner {
    private static final int SIGNATURE_LENGTH = 144;
    private final AwsCrt4aSigningAdapter aws4aSigner;
    private final AwsSigningConfig signingConfig;

    public AwsS3V4aChunkSigner(AwsCrt4aSigningAdapter aws4aSigner, AwsSigningConfig signingConfig) {
        this.aws4aSigner = aws4aSigner;
        this.signingConfig = signingConfig;
    }

    public String signChunk(byte[] chunkData, String previousSignature) {
        byte[] chunkSignature = this.aws4aSigner.signChunk(chunkData, previousSignature.getBytes(StandardCharsets.UTF_8), this.signingConfig);
        return new String(chunkSignature, StandardCharsets.UTF_8);
    }

    public String signChecksumChunk(byte[] calculatedChecksum, String previousSignature, String checksumHeaderForTrailer) {
        AwsSigningResult awsSigningResult = this.aws4aSigner.signTrailerHeaders(Collections.singletonMap(checksumHeaderForTrailer, Collections.singletonList(BinaryUtils.toBase64((byte[])calculatedChecksum))), previousSignature.getBytes(StandardCharsets.UTF_8), this.signingConfig);
        return awsSigningResult != null ? new String(awsSigningResult.getSignature(), StandardCharsets.UTF_8) : null;
    }

    public static int getSignatureLength() {
        return 144;
    }
}

