/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSessionResponse extends AthenaResponse implements
        ToCopyableBuilder<StartSessionResponse.Builder, StartSessionResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionId").getter(getter(StartSessionResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(StartSessionResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(SESSION_ID_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sessionId;

    private final String state;

    private StartSessionResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.state = builder.state;
    }

    /**
     * <p>
     * The session ID.
     * </p>
     * 
     * @return The session ID.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The state of the session. A description of each state follows.
     * </p>
     * <p>
     * <code>CREATING</code> - The session is being started, including acquiring resources.
     * </p>
     * <p>
     * <code>CREATED</code> - The session has been started.
     * </p>
     * <p>
     * <code>IDLE</code> - The session is able to accept a calculation.
     * </p>
     * <p>
     * <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
     * </p>
     * <p>
     * <code>TERMINATING</code> - The session is in the process of shutting down.
     * </p>
     * <p>
     * <code>TERMINATED</code> - The session and its resources are no longer running.
     * </p>
     * <p>
     * <code>DEGRADED</code> - The session has no healthy coordinators.
     * </p>
     * <p>
     * <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SessionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the session. A description of each state follows.</p>
     *         <p>
     *         <code>CREATING</code> - The session is being started, including acquiring resources.
     *         </p>
     *         <p>
     *         <code>CREATED</code> - The session has been started.
     *         </p>
     *         <p>
     *         <code>IDLE</code> - The session is able to accept a calculation.
     *         </p>
     *         <p>
     *         <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
     *         </p>
     *         <p>
     *         <code>TERMINATING</code> - The session is in the process of shutting down.
     *         </p>
     *         <p>
     *         <code>TERMINATED</code> - The session and its resources are no longer running.
     *         </p>
     *         <p>
     *         <code>DEGRADED</code> - The session has no healthy coordinators.
     *         </p>
     *         <p>
     *         <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
     * @see SessionState
     */
    public final SessionState state() {
        return SessionState.fromValue(state);
    }

    /**
     * <p>
     * The state of the session. A description of each state follows.
     * </p>
     * <p>
     * <code>CREATING</code> - The session is being started, including acquiring resources.
     * </p>
     * <p>
     * <code>CREATED</code> - The session has been started.
     * </p>
     * <p>
     * <code>IDLE</code> - The session is able to accept a calculation.
     * </p>
     * <p>
     * <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
     * </p>
     * <p>
     * <code>TERMINATING</code> - The session is in the process of shutting down.
     * </p>
     * <p>
     * <code>TERMINATED</code> - The session and its resources are no longer running.
     * </p>
     * <p>
     * <code>DEGRADED</code> - The session has no healthy coordinators.
     * </p>
     * <p>
     * <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SessionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the session. A description of each state follows.</p>
     *         <p>
     *         <code>CREATING</code> - The session is being started, including acquiring resources.
     *         </p>
     *         <p>
     *         <code>CREATED</code> - The session has been started.
     *         </p>
     *         <p>
     *         <code>IDLE</code> - The session is able to accept a calculation.
     *         </p>
     *         <p>
     *         <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
     *         </p>
     *         <p>
     *         <code>TERMINATING</code> - The session is in the process of shutting down.
     *         </p>
     *         <p>
     *         <code>TERMINATED</code> - The session and its resources are no longer running.
     *         </p>
     *         <p>
     *         <code>DEGRADED</code> - The session has no healthy coordinators.
     *         </p>
     *         <p>
     *         <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
     * @see SessionState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSessionResponse)) {
            return false;
        }
        StartSessionResponse other = (StartSessionResponse) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSessionResponse").add("SessionId", sessionId()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SessionId", SESSION_ID_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSessionResponse, T> g) {
        return obj -> g.apply((StartSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartSessionResponse> {
        /**
         * <p>
         * The session ID.
         * </p>
         * 
         * @param sessionId
         *        The session ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The state of the session. A description of each state follows.
         * </p>
         * <p>
         * <code>CREATING</code> - The session is being started, including acquiring resources.
         * </p>
         * <p>
         * <code>CREATED</code> - The session has been started.
         * </p>
         * <p>
         * <code>IDLE</code> - The session is able to accept a calculation.
         * </p>
         * <p>
         * <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
         * </p>
         * <p>
         * <code>TERMINATING</code> - The session is in the process of shutting down.
         * </p>
         * <p>
         * <code>TERMINATED</code> - The session and its resources are no longer running.
         * </p>
         * <p>
         * <code>DEGRADED</code> - The session has no healthy coordinators.
         * </p>
         * <p>
         * <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
         * </p>
         * 
         * @param state
         *        The state of the session. A description of each state follows.</p>
         *        <p>
         *        <code>CREATING</code> - The session is being started, including acquiring resources.
         *        </p>
         *        <p>
         *        <code>CREATED</code> - The session has been started.
         *        </p>
         *        <p>
         *        <code>IDLE</code> - The session is able to accept a calculation.
         *        </p>
         *        <p>
         *        <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
         *        </p>
         *        <p>
         *        <code>TERMINATING</code> - The session is in the process of shutting down.
         *        </p>
         *        <p>
         *        <code>TERMINATED</code> - The session and its resources are no longer running.
         *        </p>
         *        <p>
         *        <code>DEGRADED</code> - The session has no healthy coordinators.
         *        </p>
         *        <p>
         *        <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
         * @see SessionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the session. A description of each state follows.
         * </p>
         * <p>
         * <code>CREATING</code> - The session is being started, including acquiring resources.
         * </p>
         * <p>
         * <code>CREATED</code> - The session has been started.
         * </p>
         * <p>
         * <code>IDLE</code> - The session is able to accept a calculation.
         * </p>
         * <p>
         * <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
         * </p>
         * <p>
         * <code>TERMINATING</code> - The session is in the process of shutting down.
         * </p>
         * <p>
         * <code>TERMINATED</code> - The session and its resources are no longer running.
         * </p>
         * <p>
         * <code>DEGRADED</code> - The session has no healthy coordinators.
         * </p>
         * <p>
         * <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
         * </p>
         * 
         * @param state
         *        The state of the session. A description of each state follows.</p>
         *        <p>
         *        <code>CREATING</code> - The session is being started, including acquiring resources.
         *        </p>
         *        <p>
         *        <code>CREATED</code> - The session has been started.
         *        </p>
         *        <p>
         *        <code>IDLE</code> - The session is able to accept a calculation.
         *        </p>
         *        <p>
         *        <code>BUSY</code> - The session is processing another task and is unable to accept a calculation.
         *        </p>
         *        <p>
         *        <code>TERMINATING</code> - The session is in the process of shutting down.
         *        </p>
         *        <p>
         *        <code>TERMINATED</code> - The session and its resources are no longer running.
         *        </p>
         *        <p>
         *        <code>DEGRADED</code> - The session has no healthy coordinators.
         *        </p>
         *        <p>
         *        <code>FAILED</code> - Due to a failure, the session and its resources are no longer running.
         * @see SessionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionState
         */
        Builder state(SessionState state);
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private String sessionId;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSessionResponse model) {
            super(model);
            sessionId(model.sessionId);
            state(model.state);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SessionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public StartSessionResponse build() {
            return new StartSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
