/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTableMetadataRequest extends AthenaRequest implements
        ToCopyableBuilder<ListTableMetadataRequest.Builder, ListTableMetadataRequest> {
    private static final SdkField<String> CATALOG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogName").getter(getter(ListTableMetadataRequest::catalogName)).setter(setter(Builder::catalogName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogName").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(ListTableMetadataRequest::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Expression").getter(getter(ListTableMetadataRequest::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTableMetadataRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListTableMetadataRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkGroup").getter(getter(ListTableMetadataRequest::workGroup)).setter(setter(Builder::workGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_NAME_FIELD,
            DATABASE_NAME_FIELD, EXPRESSION_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, WORK_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalogName;

    private final String databaseName;

    private final String expression;

    private final String nextToken;

    private final Integer maxResults;

    private final String workGroup;

    private ListTableMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.catalogName = builder.catalogName;
        this.databaseName = builder.databaseName;
        this.expression = builder.expression;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.workGroup = builder.workGroup;
    }

    /**
     * <p>
     * The name of the data catalog for which table metadata should be returned.
     * </p>
     * 
     * @return The name of the data catalog for which table metadata should be returned.
     */
    public final String catalogName() {
        return catalogName;
    }

    /**
     * <p>
     * The name of the database for which table metadata should be returned.
     * </p>
     * 
     * @return The name of the database for which table metadata should be returned.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * A regex filter that pattern-matches table names. If no expression is supplied, metadata for all tables are
     * listed.
     * </p>
     * 
     * @return A regex filter that pattern-matches table names. If no expression is supplied, metadata for all tables
     *         are listed.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous page
     * call.
     * </p>
     * 
     * @return A token generated by the Athena service that specifies where to continue pagination if a previous request
     *         was truncated. To obtain the next set of pages, pass in the NextToken from the response object of the
     *         previous page call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the maximum number of results to return.
     * </p>
     * 
     * @return Specifies the maximum number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The name of the workgroup for which the metadata is being fetched. Required if requesting an IAM Identity Center
     * enabled Glue Data Catalog.
     * </p>
     * 
     * @return The name of the workgroup for which the metadata is being fetched. Required if requesting an IAM Identity
     *         Center enabled Glue Data Catalog.
     */
    public final String workGroup() {
        return workGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(workGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTableMetadataRequest)) {
            return false;
        }
        ListTableMetadataRequest other = (ListTableMetadataRequest) obj;
        return Objects.equals(catalogName(), other.catalogName()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(expression(), other.expression()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(workGroup(), other.workGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTableMetadataRequest").add("CatalogName", catalogName()).add("DatabaseName", databaseName())
                .add("Expression", expression()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("WorkGroup", workGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogName":
            return Optional.ofNullable(clazz.cast(catalogName()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "Expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "WorkGroup":
            return Optional.ofNullable(clazz.cast(workGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CatalogName", CATALOG_NAME_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("Expression", EXPRESSION_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("WorkGroup", WORK_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTableMetadataRequest, T> g) {
        return obj -> g.apply((ListTableMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTableMetadataRequest> {
        /**
         * <p>
         * The name of the data catalog for which table metadata should be returned.
         * </p>
         * 
         * @param catalogName
         *        The name of the data catalog for which table metadata should be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogName(String catalogName);

        /**
         * <p>
         * The name of the database for which table metadata should be returned.
         * </p>
         * 
         * @param databaseName
         *        The name of the database for which table metadata should be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * A regex filter that pattern-matches table names. If no expression is supplied, metadata for all tables are
         * listed.
         * </p>
         * 
         * @param expression
         *        A regex filter that pattern-matches table names. If no expression is supplied, metadata for all tables
         *        are listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * A token generated by the Athena service that specifies where to continue pagination if a previous request was
         * truncated. To obtain the next set of pages, pass in the NextToken from the response object of the previous
         * page call.
         * </p>
         * 
         * @param nextToken
         *        A token generated by the Athena service that specifies where to continue pagination if a previous
         *        request was truncated. To obtain the next set of pages, pass in the NextToken from the response object
         *        of the previous page call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        Specifies the maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The name of the workgroup for which the metadata is being fetched. Required if requesting an IAM Identity
         * Center enabled Glue Data Catalog.
         * </p>
         * 
         * @param workGroup
         *        The name of the workgroup for which the metadata is being fetched. Required if requesting an IAM
         *        Identity Center enabled Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroup(String workGroup);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AthenaRequest.BuilderImpl implements Builder {
        private String catalogName;

        private String databaseName;

        private String expression;

        private String nextToken;

        private Integer maxResults;

        private String workGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTableMetadataRequest model) {
            super(model);
            catalogName(model.catalogName);
            databaseName(model.databaseName);
            expression(model.expression);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            workGroup(model.workGroup);
        }

        public final String getCatalogName() {
            return catalogName;
        }

        public final void setCatalogName(String catalogName) {
            this.catalogName = catalogName;
        }

        @Override
        public final Builder catalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getWorkGroup() {
            return workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTableMetadataRequest build() {
            return new ListTableMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
