/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNotebookSessionsResponse extends AthenaResponse implements
        ToCopyableBuilder<ListNotebookSessionsResponse.Builder, ListNotebookSessionsResponse> {
    private static final SdkField<List<NotebookSessionSummary>> NOTEBOOK_SESSIONS_LIST_FIELD = SdkField
            .<List<NotebookSessionSummary>> builder(MarshallingType.LIST)
            .memberName("NotebookSessionsList")
            .getter(getter(ListNotebookSessionsResponse::notebookSessionsList))
            .setter(setter(Builder::notebookSessionsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookSessionsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NotebookSessionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(NotebookSessionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListNotebookSessionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTEBOOK_SESSIONS_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<NotebookSessionSummary> notebookSessionsList;

    private final String nextToken;

    private ListNotebookSessionsResponse(BuilderImpl builder) {
        super(builder);
        this.notebookSessionsList = builder.notebookSessionsList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotebookSessionsList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNotebookSessionsList() {
        return notebookSessionsList != null && !(notebookSessionsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the sessions belonging to the notebook.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotebookSessionsList} method.
     * </p>
     * 
     * @return A list of the sessions belonging to the notebook.
     */
    public final List<NotebookSessionSummary> notebookSessionsList() {
        return notebookSessionsList;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @return A token generated by the Athena service that specifies where to continue pagination if a previous request
     *         was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *         object of the previous page call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNotebookSessionsList() ? notebookSessionsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotebookSessionsResponse)) {
            return false;
        }
        ListNotebookSessionsResponse other = (ListNotebookSessionsResponse) obj;
        return hasNotebookSessionsList() == other.hasNotebookSessionsList()
                && Objects.equals(notebookSessionsList(), other.notebookSessionsList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNotebookSessionsResponse")
                .add("NotebookSessionsList", hasNotebookSessionsList() ? notebookSessionsList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotebookSessionsList":
            return Optional.ofNullable(clazz.cast(notebookSessionsList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NotebookSessionsList", NOTEBOOK_SESSIONS_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNotebookSessionsResponse, T> g) {
        return obj -> g.apply((ListNotebookSessionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListNotebookSessionsResponse> {
        /**
         * <p>
         * A list of the sessions belonging to the notebook.
         * </p>
         * 
         * @param notebookSessionsList
         *        A list of the sessions belonging to the notebook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookSessionsList(Collection<NotebookSessionSummary> notebookSessionsList);

        /**
         * <p>
         * A list of the sessions belonging to the notebook.
         * </p>
         * 
         * @param notebookSessionsList
         *        A list of the sessions belonging to the notebook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notebookSessionsList(NotebookSessionSummary... notebookSessionsList);

        /**
         * <p>
         * A list of the sessions belonging to the notebook.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.athena.model.NotebookSessionSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.athena.model.NotebookSessionSummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.athena.model.NotebookSessionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #notebookSessionsList(List<NotebookSessionSummary>)}.
         * 
         * @param notebookSessionsList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.athena.model.NotebookSessionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notebookSessionsList(java.util.Collection<NotebookSessionSummary>)
         */
        Builder notebookSessionsList(Consumer<NotebookSessionSummary.Builder>... notebookSessionsList);

        /**
         * <p>
         * A token generated by the Athena service that specifies where to continue pagination if a previous request was
         * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of
         * the previous page call.
         * </p>
         * 
         * @param nextToken
         *        A token generated by the Athena service that specifies where to continue pagination if a previous
         *        request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the
         *        response object of the previous page call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private List<NotebookSessionSummary> notebookSessionsList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotebookSessionsResponse model) {
            super(model);
            notebookSessionsList(model.notebookSessionsList);
            nextToken(model.nextToken);
        }

        public final List<NotebookSessionSummary.Builder> getNotebookSessionsList() {
            List<NotebookSessionSummary.Builder> result = NotebookSessionsListCopier.copyToBuilder(this.notebookSessionsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotebookSessionsList(Collection<NotebookSessionSummary.BuilderImpl> notebookSessionsList) {
            this.notebookSessionsList = NotebookSessionsListCopier.copyFromBuilder(notebookSessionsList);
        }

        @Override
        public final Builder notebookSessionsList(Collection<NotebookSessionSummary> notebookSessionsList) {
            this.notebookSessionsList = NotebookSessionsListCopier.copy(notebookSessionsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notebookSessionsList(NotebookSessionSummary... notebookSessionsList) {
            notebookSessionsList(Arrays.asList(notebookSessionsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notebookSessionsList(Consumer<NotebookSessionSummary.Builder>... notebookSessionsList) {
            notebookSessionsList(Stream.of(notebookSessionsList)
                    .map(c -> NotebookSessionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListNotebookSessionsResponse build() {
            return new ListNotebookSessionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
