/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSessionStatusResponse extends AthenaResponse implements
        ToCopyableBuilder<GetSessionStatusResponse.Builder, GetSessionStatusResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionId").getter(getter(GetSessionStatusResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()).build();

    private static final SdkField<SessionStatus> STATUS_FIELD = SdkField.<SessionStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status").getter(getter(GetSessionStatusResponse::status)).setter(setter(Builder::status))
            .constructor(SessionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SESSION_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sessionId;

    private final SessionStatus status;

    private GetSessionStatusResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The session ID.
     * </p>
     * 
     * @return The session ID.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * Contains information about the status of the session.
     * </p>
     * 
     * @return Contains information about the status of the session.
     */
    public final SessionStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionStatusResponse)) {
            return false;
        }
        GetSessionStatusResponse other = (GetSessionStatusResponse) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSessionStatusResponse").add("SessionId", sessionId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SessionId", SESSION_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSessionStatusResponse, T> g) {
        return obj -> g.apply((GetSessionStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSessionStatusResponse> {
        /**
         * <p>
         * The session ID.
         * </p>
         * 
         * @param sessionId
         *        The session ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * Contains information about the status of the session.
         * </p>
         * 
         * @param status
         *        Contains information about the status of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(SessionStatus status);

        /**
         * <p>
         * Contains information about the status of the session.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionStatus.Builder} avoiding the need
         * to create one manually via {@link SessionStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(SessionStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link SessionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(SessionStatus)
         */
        default Builder status(Consumer<SessionStatus.Builder> status) {
            return status(SessionStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private String sessionId;

        private SessionStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionStatusResponse model) {
            super(model);
            sessionId(model.sessionId);
            status(model.status);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final SessionStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(SessionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(SessionStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public GetSessionStatusResponse build() {
            return new GetSessionStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
