/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePreparedStatementRequest extends AthenaRequest implements
        ToCopyableBuilder<CreatePreparedStatementRequest.Builder, CreatePreparedStatementRequest> {
    private static final SdkField<String> STATEMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatementName").getter(getter(CreatePreparedStatementRequest::statementName))
            .setter(setter(Builder::statementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementName").build()).build();

    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkGroup").getter(getter(CreatePreparedStatementRequest::workGroup)).setter(setter(Builder::workGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()).build();

    private static final SdkField<String> QUERY_STATEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryStatement").getter(getter(CreatePreparedStatementRequest::queryStatement))
            .setter(setter(Builder::queryStatement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatement").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreatePreparedStatementRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENT_NAME_FIELD,
            WORK_GROUP_FIELD, QUERY_STATEMENT_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String statementName;

    private final String workGroup;

    private final String queryStatement;

    private final String description;

    private CreatePreparedStatementRequest(BuilderImpl builder) {
        super(builder);
        this.statementName = builder.statementName;
        this.workGroup = builder.workGroup;
        this.queryStatement = builder.queryStatement;
        this.description = builder.description;
    }

    /**
     * <p>
     * The name of the prepared statement.
     * </p>
     * 
     * @return The name of the prepared statement.
     */
    public final String statementName() {
        return statementName;
    }

    /**
     * <p>
     * The name of the workgroup to which the prepared statement belongs.
     * </p>
     * 
     * @return The name of the workgroup to which the prepared statement belongs.
     */
    public final String workGroup() {
        return workGroup;
    }

    /**
     * <p>
     * The query string for the prepared statement.
     * </p>
     * 
     * @return The query string for the prepared statement.
     */
    public final String queryStatement() {
        return queryStatement;
    }

    /**
     * <p>
     * The description of the prepared statement.
     * </p>
     * 
     * @return The description of the prepared statement.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statementName());
        hashCode = 31 * hashCode + Objects.hashCode(workGroup());
        hashCode = 31 * hashCode + Objects.hashCode(queryStatement());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePreparedStatementRequest)) {
            return false;
        }
        CreatePreparedStatementRequest other = (CreatePreparedStatementRequest) obj;
        return Objects.equals(statementName(), other.statementName()) && Objects.equals(workGroup(), other.workGroup())
                && Objects.equals(queryStatement(), other.queryStatement()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePreparedStatementRequest").add("StatementName", statementName())
                .add("WorkGroup", workGroup()).add("QueryStatement", queryStatement()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StatementName":
            return Optional.ofNullable(clazz.cast(statementName()));
        case "WorkGroup":
            return Optional.ofNullable(clazz.cast(workGroup()));
        case "QueryStatement":
            return Optional.ofNullable(clazz.cast(queryStatement()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StatementName", STATEMENT_NAME_FIELD);
        map.put("WorkGroup", WORK_GROUP_FIELD);
        map.put("QueryStatement", QUERY_STATEMENT_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePreparedStatementRequest, T> g) {
        return obj -> g.apply((CreatePreparedStatementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePreparedStatementRequest> {
        /**
         * <p>
         * The name of the prepared statement.
         * </p>
         * 
         * @param statementName
         *        The name of the prepared statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementName(String statementName);

        /**
         * <p>
         * The name of the workgroup to which the prepared statement belongs.
         * </p>
         * 
         * @param workGroup
         *        The name of the workgroup to which the prepared statement belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroup(String workGroup);

        /**
         * <p>
         * The query string for the prepared statement.
         * </p>
         * 
         * @param queryStatement
         *        The query string for the prepared statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStatement(String queryStatement);

        /**
         * <p>
         * The description of the prepared statement.
         * </p>
         * 
         * @param description
         *        The description of the prepared statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AthenaRequest.BuilderImpl implements Builder {
        private String statementName;

        private String workGroup;

        private String queryStatement;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePreparedStatementRequest model) {
            super(model);
            statementName(model.statementName);
            workGroup(model.workGroup);
            queryStatement(model.queryStatement);
            description(model.description);
        }

        public final String getStatementName() {
            return statementName;
        }

        public final void setStatementName(String statementName) {
            this.statementName = statementName;
        }

        @Override
        public final Builder statementName(String statementName) {
            this.statementName = statementName;
            return this;
        }

        public final String getWorkGroup() {
            return workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        public final String getQueryStatement() {
            return queryStatement;
        }

        public final void setQueryStatement(String queryStatement) {
            this.queryStatement = queryStatement;
        }

        @Override
        public final Builder queryStatement(String queryStatement) {
            this.queryStatement = queryStatement;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePreparedStatementRequest build() {
            return new CreatePreparedStatementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
