/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Assigns Athena workgroups (and hence their queries) to capacity reservations. A capacity reservation can have only
 * one capacity assignment configuration, but the capacity assignment configuration can be made up of multiple
 * individual assignments. Each assignment specifies how Athena queries can consume capacity from the capacity
 * reservation that their workgroup is mapped to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityAssignmentConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityAssignmentConfiguration.Builder, CapacityAssignmentConfiguration> {
    private static final SdkField<String> CAPACITY_RESERVATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationName").getter(getter(CapacityAssignmentConfiguration::capacityReservationName))
            .setter(setter(Builder::capacityReservationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationName").build())
            .build();

    private static final SdkField<List<CapacityAssignment>> CAPACITY_ASSIGNMENTS_FIELD = SdkField
            .<List<CapacityAssignment>> builder(MarshallingType.LIST)
            .memberName("CapacityAssignments")
            .getter(getter(CapacityAssignmentConfiguration::capacityAssignments))
            .setter(setter(Builder::capacityAssignments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityAssignments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CapacityAssignment> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityAssignment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CAPACITY_RESERVATION_NAME_FIELD, CAPACITY_ASSIGNMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String capacityReservationName;

    private final List<CapacityAssignment> capacityAssignments;

    private CapacityAssignmentConfiguration(BuilderImpl builder) {
        this.capacityReservationName = builder.capacityReservationName;
        this.capacityAssignments = builder.capacityAssignments;
    }

    /**
     * <p>
     * The name of the reservation that the capacity assignment configuration is for.
     * </p>
     * 
     * @return The name of the reservation that the capacity assignment configuration is for.
     */
    public final String capacityReservationName() {
        return capacityReservationName;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityAssignments property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapacityAssignments() {
        return capacityAssignments != null && !(capacityAssignments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of assignments that make up the capacity assignment configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityAssignments} method.
     * </p>
     * 
     * @return The list of assignments that make up the capacity assignment configuration.
     */
    public final List<CapacityAssignment> capacityAssignments() {
        return capacityAssignments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationName());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityAssignments() ? capacityAssignments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityAssignmentConfiguration)) {
            return false;
        }
        CapacityAssignmentConfiguration other = (CapacityAssignmentConfiguration) obj;
        return Objects.equals(capacityReservationName(), other.capacityReservationName())
                && hasCapacityAssignments() == other.hasCapacityAssignments()
                && Objects.equals(capacityAssignments(), other.capacityAssignments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityAssignmentConfiguration").add("CapacityReservationName", capacityReservationName())
                .add("CapacityAssignments", hasCapacityAssignments() ? capacityAssignments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityReservationName":
            return Optional.ofNullable(clazz.cast(capacityReservationName()));
        case "CapacityAssignments":
            return Optional.ofNullable(clazz.cast(capacityAssignments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityReservationName", CAPACITY_RESERVATION_NAME_FIELD);
        map.put("CapacityAssignments", CAPACITY_ASSIGNMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityAssignmentConfiguration, T> g) {
        return obj -> g.apply((CapacityAssignmentConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityAssignmentConfiguration> {
        /**
         * <p>
         * The name of the reservation that the capacity assignment configuration is for.
         * </p>
         * 
         * @param capacityReservationName
         *        The name of the reservation that the capacity assignment configuration is for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationName(String capacityReservationName);

        /**
         * <p>
         * The list of assignments that make up the capacity assignment configuration.
         * </p>
         * 
         * @param capacityAssignments
         *        The list of assignments that make up the capacity assignment configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityAssignments(Collection<CapacityAssignment> capacityAssignments);

        /**
         * <p>
         * The list of assignments that make up the capacity assignment configuration.
         * </p>
         * 
         * @param capacityAssignments
         *        The list of assignments that make up the capacity assignment configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityAssignments(CapacityAssignment... capacityAssignments);

        /**
         * <p>
         * The list of assignments that make up the capacity assignment configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.athena.model.CapacityAssignment.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.athena.model.CapacityAssignment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.athena.model.CapacityAssignment.Builder#build()} is called immediately
         * and its result is passed to {@link #capacityAssignments(List<CapacityAssignment>)}.
         * 
         * @param capacityAssignments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.athena.model.CapacityAssignment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityAssignments(java.util.Collection<CapacityAssignment>)
         */
        Builder capacityAssignments(Consumer<CapacityAssignment.Builder>... capacityAssignments);
    }

    static final class BuilderImpl implements Builder {
        private String capacityReservationName;

        private List<CapacityAssignment> capacityAssignments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityAssignmentConfiguration model) {
            capacityReservationName(model.capacityReservationName);
            capacityAssignments(model.capacityAssignments);
        }

        public final String getCapacityReservationName() {
            return capacityReservationName;
        }

        public final void setCapacityReservationName(String capacityReservationName) {
            this.capacityReservationName = capacityReservationName;
        }

        @Override
        public final Builder capacityReservationName(String capacityReservationName) {
            this.capacityReservationName = capacityReservationName;
            return this;
        }

        public final List<CapacityAssignment.Builder> getCapacityAssignments() {
            List<CapacityAssignment.Builder> result = CapacityAssignmentsListCopier.copyToBuilder(this.capacityAssignments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityAssignments(Collection<CapacityAssignment.BuilderImpl> capacityAssignments) {
            this.capacityAssignments = CapacityAssignmentsListCopier.copyFromBuilder(capacityAssignments);
        }

        @Override
        public final Builder capacityAssignments(Collection<CapacityAssignment> capacityAssignments) {
            this.capacityAssignments = CapacityAssignmentsListCopier.copy(capacityAssignments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityAssignments(CapacityAssignment... capacityAssignments) {
            capacityAssignments(Arrays.asList(capacityAssignments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityAssignments(Consumer<CapacityAssignment.Builder>... capacityAssignments) {
            capacityAssignments(Stream.of(capacityAssignments).map(c -> CapacityAssignment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CapacityAssignmentConfiguration build() {
            return new CapacityAssignmentConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
