/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains statistics for a notebook calculation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CalculationStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<CalculationStatistics.Builder, CalculationStatistics> {
    private static final SdkField<Long> DPU_EXECUTION_IN_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DpuExecutionInMillis").getter(getter(CalculationStatistics::dpuExecutionInMillis))
            .setter(setter(Builder::dpuExecutionInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DpuExecutionInMillis").build())
            .build();

    private static final SdkField<String> PROGRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Progress").getter(getter(CalculationStatistics::progress)).setter(setter(Builder::progress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Progress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DPU_EXECUTION_IN_MILLIS_FIELD,
            PROGRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long dpuExecutionInMillis;

    private final String progress;

    private CalculationStatistics(BuilderImpl builder) {
        this.dpuExecutionInMillis = builder.dpuExecutionInMillis;
        this.progress = builder.progress;
    }

    /**
     * <p>
     * The data processing unit execution time in milliseconds for the calculation.
     * </p>
     * 
     * @return The data processing unit execution time in milliseconds for the calculation.
     */
    public final Long dpuExecutionInMillis() {
        return dpuExecutionInMillis;
    }

    /**
     * <p>
     * The progress of the calculation.
     * </p>
     * 
     * @return The progress of the calculation.
     */
    public final String progress() {
        return progress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dpuExecutionInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(progress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculationStatistics)) {
            return false;
        }
        CalculationStatistics other = (CalculationStatistics) obj;
        return Objects.equals(dpuExecutionInMillis(), other.dpuExecutionInMillis())
                && Objects.equals(progress(), other.progress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CalculationStatistics").add("DpuExecutionInMillis", dpuExecutionInMillis())
                .add("Progress", progress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DpuExecutionInMillis":
            return Optional.ofNullable(clazz.cast(dpuExecutionInMillis()));
        case "Progress":
            return Optional.ofNullable(clazz.cast(progress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DpuExecutionInMillis", DPU_EXECUTION_IN_MILLIS_FIELD);
        map.put("Progress", PROGRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CalculationStatistics, T> g) {
        return obj -> g.apply((CalculationStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CalculationStatistics> {
        /**
         * <p>
         * The data processing unit execution time in milliseconds for the calculation.
         * </p>
         * 
         * @param dpuExecutionInMillis
         *        The data processing unit execution time in milliseconds for the calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dpuExecutionInMillis(Long dpuExecutionInMillis);

        /**
         * <p>
         * The progress of the calculation.
         * </p>
         * 
         * @param progress
         *        The progress of the calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progress(String progress);
    }

    static final class BuilderImpl implements Builder {
        private Long dpuExecutionInMillis;

        private String progress;

        private BuilderImpl() {
        }

        private BuilderImpl(CalculationStatistics model) {
            dpuExecutionInMillis(model.dpuExecutionInMillis);
            progress(model.progress);
        }

        public final Long getDpuExecutionInMillis() {
            return dpuExecutionInMillis;
        }

        public final void setDpuExecutionInMillis(Long dpuExecutionInMillis) {
            this.dpuExecutionInMillis = dpuExecutionInMillis;
        }

        @Override
        public final Builder dpuExecutionInMillis(Long dpuExecutionInMillis) {
            this.dpuExecutionInMillis = dpuExecutionInMillis;
            return this;
        }

        public final String getProgress() {
            return progress;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        @Override
        public CalculationStatistics build() {
            return new CalculationStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
