/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.ListExecutorsRequest;
import software.amazon.awssdk.services.athena.model.ListExecutorsResponse;

public class ListExecutorsPublisher
implements SdkPublisher<ListExecutorsResponse> {
    private final AthenaAsyncClient client;
    private final ListExecutorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExecutorsPublisher(AthenaAsyncClient client, ListExecutorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExecutorsPublisher(AthenaAsyncClient client, ListExecutorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExecutorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExecutorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListExecutorsResponseFetcher
    implements AsyncPageFetcher<ListExecutorsResponse> {
        private ListExecutorsResponseFetcher() {
        }

        public boolean hasNextPage(ListExecutorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListExecutorsResponse> nextPage(ListExecutorsResponse previousPage) {
            if (previousPage == null) {
                return ListExecutorsPublisher.this.client.listExecutors(ListExecutorsPublisher.this.firstRequest);
            }
            return ListExecutorsPublisher.this.client.listExecutors((ListExecutorsRequest)((Object)ListExecutorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

