/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.services.athena.model.PreparedStatementNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetPreparedStatementRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, BatchGetPreparedStatementRequest> {
    private static final SdkField<List<String>> PREPARED_STATEMENT_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PreparedStatementNames").getter(BatchGetPreparedStatementRequest.getter(BatchGetPreparedStatementRequest::preparedStatementNames)).setter(BatchGetPreparedStatementRequest.setter(Builder::preparedStatementNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreparedStatementNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkGroup").getter(BatchGetPreparedStatementRequest.getter(BatchGetPreparedStatementRequest::workGroup)).setter(BatchGetPreparedStatementRequest.setter(Builder::workGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREPARED_STATEMENT_NAMES_FIELD, WORK_GROUP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetPreparedStatementRequest.memberNameToFieldInitializer();
    private final List<String> preparedStatementNames;
    private final String workGroup;

    private BatchGetPreparedStatementRequest(BuilderImpl builder) {
        super(builder);
        this.preparedStatementNames = builder.preparedStatementNames;
        this.workGroup = builder.workGroup;
    }

    public final boolean hasPreparedStatementNames() {
        return this.preparedStatementNames != null && !(this.preparedStatementNames instanceof SdkAutoConstructList);
    }

    public final List<String> preparedStatementNames() {
        return this.preparedStatementNames;
    }

    public final String workGroup() {
        return this.workGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPreparedStatementNames() ? this.preparedStatementNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetPreparedStatementRequest)) {
            return false;
        }
        BatchGetPreparedStatementRequest other = (BatchGetPreparedStatementRequest)((Object)obj);
        return this.hasPreparedStatementNames() == other.hasPreparedStatementNames() && Objects.equals(this.preparedStatementNames(), other.preparedStatementNames()) && Objects.equals(this.workGroup(), other.workGroup());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetPreparedStatementRequest").add("PreparedStatementNames", this.hasPreparedStatementNames() ? this.preparedStatementNames() : null).add("WorkGroup", (Object)this.workGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PreparedStatementNames": {
                return Optional.ofNullable(clazz.cast(this.preparedStatementNames()));
            }
            case "WorkGroup": {
                return Optional.ofNullable(clazz.cast(this.workGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PreparedStatementNames", PREPARED_STATEMENT_NAMES_FIELD);
        map.put("WorkGroup", WORK_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetPreparedStatementRequest, T> g) {
        return obj -> g.apply((BatchGetPreparedStatementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private List<String> preparedStatementNames = DefaultSdkAutoConstructList.getInstance();
        private String workGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetPreparedStatementRequest model) {
            super(model);
            this.preparedStatementNames(model.preparedStatementNames);
            this.workGroup(model.workGroup);
        }

        public final Collection<String> getPreparedStatementNames() {
            if (this.preparedStatementNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.preparedStatementNames;
        }

        public final void setPreparedStatementNames(Collection<String> preparedStatementNames) {
            this.preparedStatementNames = PreparedStatementNameListCopier.copy(preparedStatementNames);
        }

        @Override
        public final Builder preparedStatementNames(Collection<String> preparedStatementNames) {
            this.preparedStatementNames = PreparedStatementNameListCopier.copy(preparedStatementNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder preparedStatementNames(String ... preparedStatementNames) {
            this.preparedStatementNames(Arrays.asList(preparedStatementNames));
            return this;
        }

        public final String getWorkGroup() {
            return this.workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetPreparedStatementRequest build() {
            return new BatchGetPreparedStatementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AthenaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetPreparedStatementRequest> {
        public Builder preparedStatementNames(Collection<String> var1);

        public Builder preparedStatementNames(String ... var1);

        public Builder workGroup(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

