/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.SupportedDPUSizeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationDPUSizes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationDPUSizes> {
    private static final SdkField<String> APPLICATION_RUNTIME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationRuntimeId").getter(ApplicationDPUSizes.getter(ApplicationDPUSizes::applicationRuntimeId)).setter(ApplicationDPUSizes.setter(Builder::applicationRuntimeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationRuntimeId").build()}).build();
    private static final SdkField<List<Integer>> SUPPORTED_DPU_SIZES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedDPUSizes").getter(ApplicationDPUSizes.getter(ApplicationDPUSizes::supportedDPUSizes)).setter(ApplicationDPUSizes.setter(Builder::supportedDPUSizes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedDPUSizes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_RUNTIME_ID_FIELD, SUPPORTED_DPU_SIZES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApplicationDPUSizes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String applicationRuntimeId;
    private final List<Integer> supportedDPUSizes;

    private ApplicationDPUSizes(BuilderImpl builder) {
        this.applicationRuntimeId = builder.applicationRuntimeId;
        this.supportedDPUSizes = builder.supportedDPUSizes;
    }

    public final String applicationRuntimeId() {
        return this.applicationRuntimeId;
    }

    public final boolean hasSupportedDPUSizes() {
        return this.supportedDPUSizes != null && !(this.supportedDPUSizes instanceof SdkAutoConstructList);
    }

    public final List<Integer> supportedDPUSizes() {
        return this.supportedDPUSizes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationRuntimeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedDPUSizes() ? this.supportedDPUSizes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationDPUSizes)) {
            return false;
        }
        ApplicationDPUSizes other = (ApplicationDPUSizes)obj;
        return Objects.equals(this.applicationRuntimeId(), other.applicationRuntimeId()) && this.hasSupportedDPUSizes() == other.hasSupportedDPUSizes() && Objects.equals(this.supportedDPUSizes(), other.supportedDPUSizes());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationDPUSizes").add("ApplicationRuntimeId", (Object)this.applicationRuntimeId()).add("SupportedDPUSizes", this.hasSupportedDPUSizes() ? this.supportedDPUSizes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationRuntimeId": {
                return Optional.ofNullable(clazz.cast(this.applicationRuntimeId()));
            }
            case "SupportedDPUSizes": {
                return Optional.ofNullable(clazz.cast(this.supportedDPUSizes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationRuntimeId", APPLICATION_RUNTIME_ID_FIELD);
        map.put("SupportedDPUSizes", SUPPORTED_DPU_SIZES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApplicationDPUSizes, T> g) {
        return obj -> g.apply((ApplicationDPUSizes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationRuntimeId;
        private List<Integer> supportedDPUSizes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationDPUSizes model) {
            this.applicationRuntimeId(model.applicationRuntimeId);
            this.supportedDPUSizes(model.supportedDPUSizes);
        }

        public final String getApplicationRuntimeId() {
            return this.applicationRuntimeId;
        }

        public final void setApplicationRuntimeId(String applicationRuntimeId) {
            this.applicationRuntimeId = applicationRuntimeId;
        }

        @Override
        public final Builder applicationRuntimeId(String applicationRuntimeId) {
            this.applicationRuntimeId = applicationRuntimeId;
            return this;
        }

        public final Collection<Integer> getSupportedDPUSizes() {
            if (this.supportedDPUSizes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedDPUSizes;
        }

        public final void setSupportedDPUSizes(Collection<Integer> supportedDPUSizes) {
            this.supportedDPUSizes = SupportedDPUSizeListCopier.copy(supportedDPUSizes);
        }

        @Override
        public final Builder supportedDPUSizes(Collection<Integer> supportedDPUSizes) {
            this.supportedDPUSizes = SupportedDPUSizeListCopier.copy(supportedDPUSizes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedDPUSizes(Integer ... supportedDPUSizes) {
            this.supportedDPUSizes(Arrays.asList(supportedDPUSizes));
            return this;
        }

        public ApplicationDPUSizes build() {
            return new ApplicationDPUSizes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationDPUSizes> {
        public Builder applicationRuntimeId(String var1);

        public Builder supportedDPUSizes(Collection<Integer> var1);

        public Builder supportedDPUSizes(Integer ... var1);
    }
}

