/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.internal.UserAgentUtils;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsRequest;
import software.amazon.awssdk.services.athena.model.ListQueryExecutionsResponse;

public class ListQueryExecutionsIterable
implements SdkIterable<ListQueryExecutionsResponse> {
    private final AthenaClient client;
    private final ListQueryExecutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListQueryExecutionsIterable(AthenaClient client, ListQueryExecutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListQueryExecutionsResponseFetcher();
    }

    public Iterator<ListQueryExecutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListQueryExecutionsResponseFetcher
    implements SyncPageFetcher<ListQueryExecutionsResponse> {
        private ListQueryExecutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListQueryExecutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListQueryExecutionsResponse nextPage(ListQueryExecutionsResponse previousPage) {
            if (previousPage == null) {
                return ListQueryExecutionsIterable.this.client.listQueryExecutions(ListQueryExecutionsIterable.this.firstRequest);
            }
            return ListQueryExecutionsIterable.this.client.listQueryExecutions((ListQueryExecutionsRequest)((Object)ListQueryExecutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

