/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.artifact.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AgreementType {
    CUSTOM("CUSTOM"),
    DEFAULT("DEFAULT"),
    MODIFIED("MODIFIED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AgreementType> VALUE_MAP;
    private final String value;

    private AgreementType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AgreementType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AgreementType> knownValues() {
        EnumSet<AgreementType> knownValues = EnumSet.allOf(AgreementType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AgreementType.class, AgreementType::toString);
    }
}

