/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncAsyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.ListResolversRequest;
import software.amazon.awssdk.services.appsync.model.ListResolversResponse;
import software.amazon.awssdk.services.appsync.model.Resolver;

public class ListResolversPublisher
implements SdkPublisher<ListResolversResponse> {
    private final AppSyncAsyncClient client;
    private final ListResolversRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResolversPublisher(AppSyncAsyncClient client, ListResolversRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResolversPublisher(AppSyncAsyncClient client, ListResolversRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResolversResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResolversResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Resolver> resolvers() {
        Function<ListResolversResponse, Iterator> getIterator = response -> {
            if (response != null && response.resolvers() != null) {
                return response.resolvers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResolversResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResolversResponseFetcher
    implements AsyncPageFetcher<ListResolversResponse> {
        private ListResolversResponseFetcher() {
        }

        public boolean hasNextPage(ListResolversResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResolversResponse> nextPage(ListResolversResponse previousPage) {
            if (previousPage == null) {
                return ListResolversPublisher.this.client.listResolvers(ListResolversPublisher.this.firstRequest);
            }
            return ListResolversPublisher.this.client.listResolvers((ListResolversRequest)((Object)ListResolversPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

