/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.ListResolversRequest;
import software.amazon.awssdk.services.appsync.model.ListResolversResponse;
import software.amazon.awssdk.services.appsync.model.Resolver;

public class ListResolversIterable
implements SdkIterable<ListResolversResponse> {
    private final AppSyncClient client;
    private final ListResolversRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResolversIterable(AppSyncClient client, ListResolversRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResolversResponseFetcher();
    }

    public Iterator<ListResolversResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Resolver> resolvers() {
        Function<ListResolversResponse, Iterator> getIterator = response -> {
            if (response != null && response.resolvers() != null) {
                return response.resolvers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResolversResponseFetcher
    implements SyncPageFetcher<ListResolversResponse> {
        private ListResolversResponseFetcher() {
        }

        public boolean hasNextPage(ListResolversResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResolversResponse nextPage(ListResolversResponse previousPage) {
            if (previousPage == null) {
                return ListResolversIterable.this.client.listResolvers(ListResolversIterable.this.firstRequest);
            }
            return ListResolversIterable.this.client.listResolvers((ListResolversRequest)((Object)ListResolversIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

