/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncAsyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.Api;
import software.amazon.awssdk.services.appsync.model.ListApisRequest;
import software.amazon.awssdk.services.appsync.model.ListApisResponse;

public class ListApisPublisher
implements SdkPublisher<ListApisResponse> {
    private final AppSyncAsyncClient client;
    private final ListApisRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApisPublisher(AppSyncAsyncClient client, ListApisRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApisPublisher(AppSyncAsyncClient client, ListApisRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApisResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApisResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Api> apis() {
        Function<ListApisResponse, Iterator> getIterator = response -> {
            if (response != null && response.apis() != null) {
                return response.apis().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListApisResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListApisResponseFetcher
    implements AsyncPageFetcher<ListApisResponse> {
        private ListApisResponseFetcher() {
        }

        public boolean hasNextPage(ListApisResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApisResponse> nextPage(ListApisResponse previousPage) {
            if (previousPage == null) {
                return ListApisPublisher.this.client.listApis(ListApisPublisher.this.firstRequest);
            }
            return ListApisPublisher.this.client.listApis((ListApisRequest)((Object)ListApisPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

