/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.ApiKey;
import software.amazon.awssdk.services.appsync.model.ListApiKeysRequest;
import software.amazon.awssdk.services.appsync.model.ListApiKeysResponse;

public class ListApiKeysIterable
implements SdkIterable<ListApiKeysResponse> {
    private final AppSyncClient client;
    private final ListApiKeysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApiKeysIterable(AppSyncClient client, ListApiKeysRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApiKeysResponseFetcher();
    }

    public Iterator<ListApiKeysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ApiKey> apiKeys() {
        Function<ListApiKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.apiKeys() != null) {
                return response.apiKeys().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListApiKeysResponseFetcher
    implements SyncPageFetcher<ListApiKeysResponse> {
        private ListApiKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListApiKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApiKeysResponse nextPage(ListApiKeysResponse previousPage) {
            if (previousPage == null) {
                return ListApiKeysIterable.this.client.listApiKeys(ListApiKeysIterable.this.firstRequest);
            }
            return ListApiKeysIterable.this.client.listApiKeys((ListApiKeysRequest)((Object)ListApiKeysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

