/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.AssociationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApiAssociation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApiAssociation> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(ApiAssociation.getter(ApiAssociation::domainName)).setter(ApiAssociation.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("apiId").getter(ApiAssociation.getter(ApiAssociation::apiId)).setter(ApiAssociation.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiId").build()}).build();
    private static final SdkField<String> ASSOCIATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationStatus").getter(ApiAssociation.getter(ApiAssociation::associationStatusAsString)).setter(ApiAssociation.setter(Builder::associationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationStatus").build()}).build();
    private static final SdkField<String> DEPLOYMENT_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentDetail").getter(ApiAssociation.getter(ApiAssociation::deploymentDetail)).setter(ApiAssociation.setter(Builder::deploymentDetail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentDetail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, API_ID_FIELD, ASSOCIATION_STATUS_FIELD, DEPLOYMENT_DETAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApiAssociation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final String apiId;
    private final String associationStatus;
    private final String deploymentDetail;

    private ApiAssociation(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.apiId = builder.apiId;
        this.associationStatus = builder.associationStatus;
        this.deploymentDetail = builder.deploymentDetail;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String apiId() {
        return this.apiId;
    }

    public final AssociationStatus associationStatus() {
        return AssociationStatus.fromValue(this.associationStatus);
    }

    public final String associationStatusAsString() {
        return this.associationStatus;
    }

    public final String deploymentDetail() {
        return this.deploymentDetail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentDetail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiAssociation)) {
            return false;
        }
        ApiAssociation other = (ApiAssociation)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.associationStatusAsString(), other.associationStatusAsString()) && Objects.equals(this.deploymentDetail(), other.deploymentDetail());
    }

    public final String toString() {
        return ToString.builder((String)"ApiAssociation").add("DomainName", (Object)this.domainName()).add("ApiId", (Object)this.apiId()).add("AssociationStatus", (Object)this.associationStatusAsString()).add("DeploymentDetail", (Object)this.deploymentDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "apiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "associationStatus": {
                return Optional.ofNullable(clazz.cast(this.associationStatusAsString()));
            }
            case "deploymentDetail": {
                return Optional.ofNullable(clazz.cast(this.deploymentDetail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("domainName", DOMAIN_NAME_FIELD);
        map.put("apiId", API_ID_FIELD);
        map.put("associationStatus", ASSOCIATION_STATUS_FIELD);
        map.put("deploymentDetail", DEPLOYMENT_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApiAssociation, T> g) {
        return obj -> g.apply((ApiAssociation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String apiId;
        private String associationStatus;
        private String deploymentDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiAssociation model) {
            this.domainName(model.domainName);
            this.apiId(model.apiId);
            this.associationStatus(model.associationStatus);
            this.deploymentDetail(model.deploymentDetail);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getApiId() {
            return this.apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getAssociationStatus() {
            return this.associationStatus;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        @Override
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        @Override
        public final Builder associationStatus(AssociationStatus associationStatus) {
            this.associationStatus(associationStatus == null ? null : associationStatus.toString());
            return this;
        }

        public final String getDeploymentDetail() {
            return this.deploymentDetail;
        }

        public final void setDeploymentDetail(String deploymentDetail) {
            this.deploymentDetail = deploymentDetail;
        }

        @Override
        public final Builder deploymentDetail(String deploymentDetail) {
            this.deploymentDetail = deploymentDetail;
            return this;
        }

        public ApiAssociation build() {
            return new ApiAssociation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApiAssociation> {
        public Builder domainName(String var1);

        public Builder apiId(String var1);

        public Builder associationStatus(String var1);

        public Builder associationStatus(AssociationStatus var1);

        public Builder deploymentDetail(String var1);
    }
}

