/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appsync.model.AppSyncResponse;
import software.amazon.awssdk.services.appsync.model.EvaluateCodeErrorDetail;
import software.amazon.awssdk.services.appsync.model.LogsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluateCodeResponse
extends AppSyncResponse
implements ToCopyableBuilder<Builder, EvaluateCodeResponse> {
    private static final SdkField<String> EVALUATION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluationResult").getter(EvaluateCodeResponse.getter(EvaluateCodeResponse::evaluationResult)).setter(EvaluateCodeResponse.setter(Builder::evaluationResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationResult").build()}).build();
    private static final SdkField<EvaluateCodeErrorDetail> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("error").getter(EvaluateCodeResponse.getter(EvaluateCodeResponse::error)).setter(EvaluateCodeResponse.setter(Builder::error)).constructor(EvaluateCodeErrorDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<List<String>> LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("logs").getter(EvaluateCodeResponse.getter(EvaluateCodeResponse::logs)).setter(EvaluateCodeResponse.setter(Builder::logs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_RESULT_FIELD, ERROR_FIELD, LOGS_FIELD));
    private final String evaluationResult;
    private final EvaluateCodeErrorDetail error;
    private final List<String> logs;

    private EvaluateCodeResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationResult = builder.evaluationResult;
        this.error = builder.error;
        this.logs = builder.logs;
    }

    public final String evaluationResult() {
        return this.evaluationResult;
    }

    public final EvaluateCodeErrorDetail error() {
        return this.error;
    }

    public final boolean hasLogs() {
        return this.logs != null && !(this.logs instanceof SdkAutoConstructList);
    }

    public final List<String> logs() {
        return this.logs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogs() ? this.logs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateCodeResponse)) {
            return false;
        }
        EvaluateCodeResponse other = (EvaluateCodeResponse)((Object)obj);
        return Objects.equals(this.evaluationResult(), other.evaluationResult()) && Objects.equals(this.error(), other.error()) && this.hasLogs() == other.hasLogs() && Objects.equals(this.logs(), other.logs());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluateCodeResponse").add("EvaluationResult", (Object)this.evaluationResult()).add("Error", (Object)this.error()).add("Logs", this.hasLogs() ? this.logs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "evaluationResult": {
                return Optional.ofNullable(clazz.cast(this.evaluationResult()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "logs": {
                return Optional.ofNullable(clazz.cast(this.logs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluateCodeResponse, T> g) {
        return obj -> g.apply((EvaluateCodeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncResponse.BuilderImpl
    implements Builder {
        private String evaluationResult;
        private EvaluateCodeErrorDetail error;
        private List<String> logs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateCodeResponse model) {
            super(model);
            this.evaluationResult(model.evaluationResult);
            this.error(model.error);
            this.logs(model.logs);
        }

        public final String getEvaluationResult() {
            return this.evaluationResult;
        }

        public final void setEvaluationResult(String evaluationResult) {
            this.evaluationResult = evaluationResult;
        }

        @Override
        public final Builder evaluationResult(String evaluationResult) {
            this.evaluationResult = evaluationResult;
            return this;
        }

        public final EvaluateCodeErrorDetail.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(EvaluateCodeErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(EvaluateCodeErrorDetail error) {
            this.error = error;
            return this;
        }

        public final Collection<String> getLogs() {
            if (this.logs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logs;
        }

        public final void setLogs(Collection<String> logs) {
            this.logs = LogsCopier.copy(logs);
        }

        @Override
        public final Builder logs(Collection<String> logs) {
            this.logs = LogsCopier.copy(logs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logs(String ... logs) {
            this.logs(Arrays.asList(logs));
            return this;
        }

        @Override
        public EvaluateCodeResponse build() {
            return new EvaluateCodeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppSyncResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EvaluateCodeResponse> {
        public Builder evaluationResult(String var1);

        public Builder error(EvaluateCodeErrorDetail var1);

        default public Builder error(Consumer<EvaluateCodeErrorDetail.Builder> error) {
            return this.error((EvaluateCodeErrorDetail)((EvaluateCodeErrorDetail.Builder)EvaluateCodeErrorDetail.builder().applyMutation(error)).build());
        }

        public Builder logs(Collection<String> var1);

        public Builder logs(String ... var1);
    }
}

