/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSchemaMergeResponse extends AppSyncResponse implements
        ToCopyableBuilder<StartSchemaMergeResponse.Builder, StartSchemaMergeResponse> {
    private static final SdkField<String> SOURCE_API_ASSOCIATION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("sourceApiAssociationStatus")
            .getter(getter(StartSchemaMergeResponse::sourceApiAssociationStatusAsString))
            .setter(setter(Builder::sourceApiAssociationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceApiAssociationStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SOURCE_API_ASSOCIATION_STATUS_FIELD));

    private final String sourceApiAssociationStatus;

    private StartSchemaMergeResponse(BuilderImpl builder) {
        super(builder);
        this.sourceApiAssociationStatus = builder.sourceApiAssociationStatus;
    }

    /**
     * <p>
     * The state of the source API association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourceApiAssociationStatus} will return {@link SourceApiAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #sourceApiAssociationStatusAsString}.
     * </p>
     * 
     * @return The state of the source API association.
     * @see SourceApiAssociationStatus
     */
    public final SourceApiAssociationStatus sourceApiAssociationStatus() {
        return SourceApiAssociationStatus.fromValue(sourceApiAssociationStatus);
    }

    /**
     * <p>
     * The state of the source API association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sourceApiAssociationStatus} will return {@link SourceApiAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #sourceApiAssociationStatusAsString}.
     * </p>
     * 
     * @return The state of the source API association.
     * @see SourceApiAssociationStatus
     */
    public final String sourceApiAssociationStatusAsString() {
        return sourceApiAssociationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceApiAssociationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSchemaMergeResponse)) {
            return false;
        }
        StartSchemaMergeResponse other = (StartSchemaMergeResponse) obj;
        return Objects.equals(sourceApiAssociationStatusAsString(), other.sourceApiAssociationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSchemaMergeResponse")
                .add("SourceApiAssociationStatus", sourceApiAssociationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceApiAssociationStatus":
            return Optional.ofNullable(clazz.cast(sourceApiAssociationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSchemaMergeResponse, T> g) {
        return obj -> g.apply((StartSchemaMergeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartSchemaMergeResponse> {
        /**
         * <p>
         * The state of the source API association.
         * </p>
         * 
         * @param sourceApiAssociationStatus
         *        The state of the source API association.
         * @see SourceApiAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceApiAssociationStatus
         */
        Builder sourceApiAssociationStatus(String sourceApiAssociationStatus);

        /**
         * <p>
         * The state of the source API association.
         * </p>
         * 
         * @param sourceApiAssociationStatus
         *        The state of the source API association.
         * @see SourceApiAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceApiAssociationStatus
         */
        Builder sourceApiAssociationStatus(SourceApiAssociationStatus sourceApiAssociationStatus);
    }

    static final class BuilderImpl extends AppSyncResponse.BuilderImpl implements Builder {
        private String sourceApiAssociationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSchemaMergeResponse model) {
            super(model);
            sourceApiAssociationStatus(model.sourceApiAssociationStatus);
        }

        public final String getSourceApiAssociationStatus() {
            return sourceApiAssociationStatus;
        }

        public final void setSourceApiAssociationStatus(String sourceApiAssociationStatus) {
            this.sourceApiAssociationStatus = sourceApiAssociationStatus;
        }

        @Override
        public final Builder sourceApiAssociationStatus(String sourceApiAssociationStatus) {
            this.sourceApiAssociationStatus = sourceApiAssociationStatus;
            return this;
        }

        @Override
        public final Builder sourceApiAssociationStatus(SourceApiAssociationStatus sourceApiAssociationStatus) {
            this.sourceApiAssociationStatus(sourceApiAssociationStatus == null ? null : sourceApiAssociationStatus.toString());
            return this;
        }

        @Override
        public StartSchemaMergeResponse build() {
            return new StartSchemaMergeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
