/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the introspected data that was retrieved from the data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceIntrospectionModel implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceIntrospectionModel.Builder, DataSourceIntrospectionModel> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DataSourceIntrospectionModel::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<DataSourceIntrospectionModelField>> FIELDS_FIELD = SdkField
            .<List<DataSourceIntrospectionModelField>> builder(MarshallingType.LIST)
            .memberName("fields")
            .getter(getter(DataSourceIntrospectionModel::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceIntrospectionModelField> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceIntrospectionModelField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DataSourceIntrospectionModelIndex> PRIMARY_KEY_FIELD = SdkField
            .<DataSourceIntrospectionModelIndex> builder(MarshallingType.SDK_POJO).memberName("primaryKey")
            .getter(getter(DataSourceIntrospectionModel::primaryKey)).setter(setter(Builder::primaryKey))
            .constructor(DataSourceIntrospectionModelIndex::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryKey").build()).build();

    private static final SdkField<List<DataSourceIntrospectionModelIndex>> INDEXES_FIELD = SdkField
            .<List<DataSourceIntrospectionModelIndex>> builder(MarshallingType.LIST)
            .memberName("indexes")
            .getter(getter(DataSourceIntrospectionModel::indexes))
            .setter(setter(Builder::indexes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSourceIntrospectionModelIndex> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSourceIntrospectionModelIndex::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SDL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sdl")
            .getter(getter(DataSourceIntrospectionModel::sdl)).setter(setter(Builder::sdl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sdl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FIELDS_FIELD,
            PRIMARY_KEY_FIELD, INDEXES_FIELD, SDL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<DataSourceIntrospectionModelField> fields;

    private final DataSourceIntrospectionModelIndex primaryKey;

    private final List<DataSourceIntrospectionModelIndex> indexes;

    private final String sdl;

    private DataSourceIntrospectionModel(BuilderImpl builder) {
        this.name = builder.name;
        this.fields = builder.fields;
        this.primaryKey = builder.primaryKey;
        this.indexes = builder.indexes;
        this.sdl = builder.sdl;
    }

    /**
     * <p>
     * The name of the model. For example, this could be the name of a single table in a database.
     * </p>
     * 
     * @return The name of the model. For example, this could be the name of a single table in a database.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>DataSourceIntrospectionModelField</code> object data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return The <code>DataSourceIntrospectionModelField</code> object data.
     */
    public final List<DataSourceIntrospectionModelField> fields() {
        return fields;
    }

    /**
     * <p>
     * The primary key stored as a <code>DataSourceIntrospectionModelIndex</code> object.
     * </p>
     * 
     * @return The primary key stored as a <code>DataSourceIntrospectionModelIndex</code> object.
     */
    public final DataSourceIntrospectionModelIndex primaryKey() {
        return primaryKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the Indexes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIndexes() {
        return indexes != null && !(indexes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The array of <code>DataSourceIntrospectionModelIndex</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIndexes} method.
     * </p>
     * 
     * @return The array of <code>DataSourceIntrospectionModelIndex</code> objects.
     */
    public final List<DataSourceIntrospectionModelIndex> indexes() {
        return indexes;
    }

    /**
     * <p>
     * Contains the output of the SDL that was generated from the introspected types. This is controlled by the
     * <code>includeModelsSDL</code> parameter of the <code>GetDataSourceIntrospection</code> operation.
     * </p>
     * 
     * @return Contains the output of the SDL that was generated from the introspected types. This is controlled by the
     *         <code>includeModelsSDL</code> parameter of the <code>GetDataSourceIntrospection</code> operation.
     */
    public final String sdl() {
        return sdl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(primaryKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasIndexes() ? indexes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sdl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceIntrospectionModel)) {
            return false;
        }
        DataSourceIntrospectionModel other = (DataSourceIntrospectionModel) obj;
        return Objects.equals(name(), other.name()) && hasFields() == other.hasFields()
                && Objects.equals(fields(), other.fields()) && Objects.equals(primaryKey(), other.primaryKey())
                && hasIndexes() == other.hasIndexes() && Objects.equals(indexes(), other.indexes())
                && Objects.equals(sdl(), other.sdl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceIntrospectionModel").add("Name", name()).add("Fields", hasFields() ? fields() : null)
                .add("PrimaryKey", primaryKey()).add("Indexes", hasIndexes() ? indexes() : null).add("Sdl", sdl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "primaryKey":
            return Optional.ofNullable(clazz.cast(primaryKey()));
        case "indexes":
            return Optional.ofNullable(clazz.cast(indexes()));
        case "sdl":
            return Optional.ofNullable(clazz.cast(sdl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceIntrospectionModel, T> g) {
        return obj -> g.apply((DataSourceIntrospectionModel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceIntrospectionModel> {
        /**
         * <p>
         * The name of the model. For example, this could be the name of a single table in a database.
         * </p>
         * 
         * @param name
         *        The name of the model. For example, this could be the name of a single table in a database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The <code>DataSourceIntrospectionModelField</code> object data.
         * </p>
         * 
         * @param fields
         *        The <code>DataSourceIntrospectionModelField</code> object data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Collection<DataSourceIntrospectionModelField> fields);

        /**
         * <p>
         * The <code>DataSourceIntrospectionModelField</code> object data.
         * </p>
         * 
         * @param fields
         *        The <code>DataSourceIntrospectionModelField</code> object data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(DataSourceIntrospectionModelField... fields);

        /**
         * <p>
         * The <code>DataSourceIntrospectionModelField</code> object data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionModelField.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionModelField#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionModelField.Builder#build()} is
         * called immediately and its result is passed to {@link #fields(List<DataSourceIntrospectionModelField>)}.
         * 
         * @param fields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionModelField.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fields(java.util.Collection<DataSourceIntrospectionModelField>)
         */
        Builder fields(Consumer<DataSourceIntrospectionModelField.Builder>... fields);

        /**
         * <p>
         * The primary key stored as a <code>DataSourceIntrospectionModelIndex</code> object.
         * </p>
         * 
         * @param primaryKey
         *        The primary key stored as a <code>DataSourceIntrospectionModelIndex</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryKey(DataSourceIntrospectionModelIndex primaryKey);

        /**
         * <p>
         * The primary key stored as a <code>DataSourceIntrospectionModelIndex</code> object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataSourceIntrospectionModelIndex.Builder} avoiding the need to create one manually via
         * {@link DataSourceIntrospectionModelIndex#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceIntrospectionModelIndex.Builder#build()} is called
         * immediately and its result is passed to {@link #primaryKey(DataSourceIntrospectionModelIndex)}.
         * 
         * @param primaryKey
         *        a consumer that will call methods on {@link DataSourceIntrospectionModelIndex.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryKey(DataSourceIntrospectionModelIndex)
         */
        default Builder primaryKey(Consumer<DataSourceIntrospectionModelIndex.Builder> primaryKey) {
            return primaryKey(DataSourceIntrospectionModelIndex.builder().applyMutation(primaryKey).build());
        }

        /**
         * <p>
         * The array of <code>DataSourceIntrospectionModelIndex</code> objects.
         * </p>
         * 
         * @param indexes
         *        The array of <code>DataSourceIntrospectionModelIndex</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexes(Collection<DataSourceIntrospectionModelIndex> indexes);

        /**
         * <p>
         * The array of <code>DataSourceIntrospectionModelIndex</code> objects.
         * </p>
         * 
         * @param indexes
         *        The array of <code>DataSourceIntrospectionModelIndex</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexes(DataSourceIntrospectionModelIndex... indexes);

        /**
         * <p>
         * The array of <code>DataSourceIntrospectionModelIndex</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionModelIndex.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionModelIndex#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionModelIndex.Builder#build()} is
         * called immediately and its result is passed to {@link #indexes(List<DataSourceIntrospectionModelIndex>)}.
         * 
         * @param indexes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appsync.model.DataSourceIntrospectionModelIndex.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #indexes(java.util.Collection<DataSourceIntrospectionModelIndex>)
         */
        Builder indexes(Consumer<DataSourceIntrospectionModelIndex.Builder>... indexes);

        /**
         * <p>
         * Contains the output of the SDL that was generated from the introspected types. This is controlled by the
         * <code>includeModelsSDL</code> parameter of the <code>GetDataSourceIntrospection</code> operation.
         * </p>
         * 
         * @param sdl
         *        Contains the output of the SDL that was generated from the introspected types. This is controlled by
         *        the <code>includeModelsSDL</code> parameter of the <code>GetDataSourceIntrospection</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sdl(String sdl);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<DataSourceIntrospectionModelField> fields = DefaultSdkAutoConstructList.getInstance();

        private DataSourceIntrospectionModelIndex primaryKey;

        private List<DataSourceIntrospectionModelIndex> indexes = DefaultSdkAutoConstructList.getInstance();

        private String sdl;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceIntrospectionModel model) {
            name(model.name);
            fields(model.fields);
            primaryKey(model.primaryKey);
            indexes(model.indexes);
            sdl(model.sdl);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<DataSourceIntrospectionModelField.Builder> getFields() {
            List<DataSourceIntrospectionModelField.Builder> result = DataSourceIntrospectionModelFieldsCopier
                    .copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<DataSourceIntrospectionModelField.BuilderImpl> fields) {
            this.fields = DataSourceIntrospectionModelFieldsCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<DataSourceIntrospectionModelField> fields) {
            this.fields = DataSourceIntrospectionModelFieldsCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(DataSourceIntrospectionModelField... fields) {
            fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<DataSourceIntrospectionModelField.Builder>... fields) {
            fields(Stream.of(fields).map(c -> DataSourceIntrospectionModelField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final DataSourceIntrospectionModelIndex.Builder getPrimaryKey() {
            return primaryKey != null ? primaryKey.toBuilder() : null;
        }

        public final void setPrimaryKey(DataSourceIntrospectionModelIndex.BuilderImpl primaryKey) {
            this.primaryKey = primaryKey != null ? primaryKey.build() : null;
        }

        @Override
        public final Builder primaryKey(DataSourceIntrospectionModelIndex primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public final List<DataSourceIntrospectionModelIndex.Builder> getIndexes() {
            List<DataSourceIntrospectionModelIndex.Builder> result = DataSourceIntrospectionModelIndexesCopier
                    .copyToBuilder(this.indexes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIndexes(Collection<DataSourceIntrospectionModelIndex.BuilderImpl> indexes) {
            this.indexes = DataSourceIntrospectionModelIndexesCopier.copyFromBuilder(indexes);
        }

        @Override
        public final Builder indexes(Collection<DataSourceIntrospectionModelIndex> indexes) {
            this.indexes = DataSourceIntrospectionModelIndexesCopier.copy(indexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexes(DataSourceIntrospectionModelIndex... indexes) {
            indexes(Arrays.asList(indexes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexes(Consumer<DataSourceIntrospectionModelIndex.Builder>... indexes) {
            indexes(Stream.of(indexes).map(c -> DataSourceIntrospectionModelIndex.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSdl() {
            return sdl;
        }

        public final void setSdl(String sdl) {
            this.sdl = sdl;
        }

        @Override
        public final Builder sdl(String sdl) {
            this.sdl = sdl;
            return this;
        }

        @Override
        public DataSourceIntrospectionModel build() {
            return new DataSourceIntrospectionModel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
