/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSchemaMergeRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, StartSchemaMergeRequest> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("associationId").getter(StartSchemaMergeRequest.getter(StartSchemaMergeRequest::associationId)).setter(StartSchemaMergeRequest.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("associationId").build()}).build();
    private static final SdkField<String> MERGED_API_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mergedApiIdentifier").getter(StartSchemaMergeRequest.getter(StartSchemaMergeRequest::mergedApiIdentifier)).setter(StartSchemaMergeRequest.setter(Builder::mergedApiIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("mergedApiIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, MERGED_API_IDENTIFIER_FIELD));
    private final String associationId;
    private final String mergedApiIdentifier;

    private StartSchemaMergeRequest(BuilderImpl builder) {
        super(builder);
        this.associationId = builder.associationId;
        this.mergedApiIdentifier = builder.mergedApiIdentifier;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final String mergedApiIdentifier() {
        return this.mergedApiIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergedApiIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSchemaMergeRequest)) {
            return false;
        }
        StartSchemaMergeRequest other = (StartSchemaMergeRequest)((Object)obj);
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.mergedApiIdentifier(), other.mergedApiIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"StartSchemaMergeRequest").add("AssociationId", (Object)this.associationId()).add("MergedApiIdentifier", (Object)this.mergedApiIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "mergedApiIdentifier": {
                return Optional.ofNullable(clazz.cast(this.mergedApiIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSchemaMergeRequest, T> g) {
        return obj -> g.apply((StartSchemaMergeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private String associationId;
        private String mergedApiIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSchemaMergeRequest model) {
            super(model);
            this.associationId(model.associationId);
            this.mergedApiIdentifier(model.mergedApiIdentifier);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getMergedApiIdentifier() {
            return this.mergedApiIdentifier;
        }

        public final void setMergedApiIdentifier(String mergedApiIdentifier) {
            this.mergedApiIdentifier = mergedApiIdentifier;
        }

        @Override
        public final Builder mergedApiIdentifier(String mergedApiIdentifier) {
            this.mergedApiIdentifier = mergedApiIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSchemaMergeRequest build() {
            return new StartSchemaMergeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSchemaMergeRequest> {
        public Builder associationId(String var1);

        public Builder mergedApiIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

