/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a runtime used by an AWS AppSync pipeline resolver or AWS AppSync function. Specifies the name and version
 * of the runtime to use. Note that if a runtime is specified, code must also be specified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppSyncRuntime implements SdkPojo, Serializable, ToCopyableBuilder<AppSyncRuntime.Builder, AppSyncRuntime> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AppSyncRuntime::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> RUNTIME_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runtimeVersion").getter(getter(AppSyncRuntime::runtimeVersion)).setter(setter(Builder::runtimeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            RUNTIME_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String runtimeVersion;

    private AppSyncRuntime(BuilderImpl builder) {
        this.name = builder.name;
        this.runtimeVersion = builder.runtimeVersion;
    }

    /**
     * <p>
     * The <code>name</code> of the runtime to use. Currently, the only allowed value is <code>APPSYNC_JS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link RuntimeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The <code>name</code> of the runtime to use. Currently, the only allowed value is <code>APPSYNC_JS</code>
     *         .
     * @see RuntimeName
     */
    public final RuntimeName name() {
        return RuntimeName.fromValue(name);
    }

    /**
     * <p>
     * The <code>name</code> of the runtime to use. Currently, the only allowed value is <code>APPSYNC_JS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link RuntimeName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The <code>name</code> of the runtime to use. Currently, the only allowed value is <code>APPSYNC_JS</code>
     *         .
     * @see RuntimeName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The <code>version</code> of the runtime to use. Currently, the only allowed version is <code>1.0.0</code>.
     * </p>
     * 
     * @return The <code>version</code> of the runtime to use. Currently, the only allowed version is <code>1.0.0</code>
     *         .
     */
    public final String runtimeVersion() {
        return runtimeVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppSyncRuntime)) {
            return false;
        }
        AppSyncRuntime other = (AppSyncRuntime) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(runtimeVersion(), other.runtimeVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppSyncRuntime").add("Name", nameAsString()).add("RuntimeVersion", runtimeVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "runtimeVersion":
            return Optional.ofNullable(clazz.cast(runtimeVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppSyncRuntime, T> g) {
        return obj -> g.apply((AppSyncRuntime) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppSyncRuntime> {
        /**
         * <p>
         * The <code>name</code> of the runtime to use. Currently, the only allowed value is <code>APPSYNC_JS</code>.
         * </p>
         * 
         * @param name
         *        The <code>name</code> of the runtime to use. Currently, the only allowed value is
         *        <code>APPSYNC_JS</code>.
         * @see RuntimeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuntimeName
         */
        Builder name(String name);

        /**
         * <p>
         * The <code>name</code> of the runtime to use. Currently, the only allowed value is <code>APPSYNC_JS</code>.
         * </p>
         * 
         * @param name
         *        The <code>name</code> of the runtime to use. Currently, the only allowed value is
         *        <code>APPSYNC_JS</code>.
         * @see RuntimeName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuntimeName
         */
        Builder name(RuntimeName name);

        /**
         * <p>
         * The <code>version</code> of the runtime to use. Currently, the only allowed version is <code>1.0.0</code>.
         * </p>
         * 
         * @param runtimeVersion
         *        The <code>version</code> of the runtime to use. Currently, the only allowed version is
         *        <code>1.0.0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeVersion(String runtimeVersion);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String runtimeVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(AppSyncRuntime model) {
            name(model.name);
            runtimeVersion(model.runtimeVersion);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(RuntimeName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getRuntimeVersion() {
            return runtimeVersion;
        }

        public final void setRuntimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
        }

        @Override
        public final Builder runtimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
            return this;
        }

        @Override
        public AppSyncRuntime build() {
            return new AppSyncRuntime(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
