/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateFleetRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateFleetRequest.Builder, UpdateFleetRequest> {
    private final String imageName;

    private final String name;

    private final String instanceType;

    private final ComputeCapacity computeCapacity;

    private final VpcConfig vpcConfig;

    private final Integer maxUserDurationInSeconds;

    private final Integer disconnectTimeoutInSeconds;

    private final Boolean deleteVpcConfig;

    private final String description;

    private final String displayName;

    private final Boolean enableDefaultInternetAccess;

    private final DomainJoinInfo domainJoinInfo;

    private final List<String> attributesToDelete;

    private UpdateFleetRequest(BuilderImpl builder) {
        this.imageName = builder.imageName;
        this.name = builder.name;
        this.instanceType = builder.instanceType;
        this.computeCapacity = builder.computeCapacity;
        this.vpcConfig = builder.vpcConfig;
        this.maxUserDurationInSeconds = builder.maxUserDurationInSeconds;
        this.disconnectTimeoutInSeconds = builder.disconnectTimeoutInSeconds;
        this.deleteVpcConfig = builder.deleteVpcConfig;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
        this.domainJoinInfo = builder.domainJoinInfo;
        this.attributesToDelete = builder.attributesToDelete;
    }

    /**
     * <p>
     * The name of the image used by the fleet.
     * </p>
     * 
     * @return The name of the image used by the fleet.
     */
    public String imageName() {
        return imageName;
    }

    /**
     * <p>
     * A unique name for the fleet.
     * </p>
     * 
     * @return A unique name for the fleet.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The instance type to use when launching fleet instances. The following instance types are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * stream.standard.medium
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.standard.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.compute.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.compute.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.compute.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.compute.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.compute.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-design.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-design.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-design.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-design.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-desktop.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-pro.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-pro.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-pro.16xlarge
     * </p>
     * </li>
     * </ul>
     * 
     * @return The instance type to use when launching fleet instances. The following instance types are available:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         stream.standard.medium
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.standard.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.compute.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.compute.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.compute.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.compute.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.compute.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-design.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-design.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-design.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-design.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-desktop.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-pro.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-pro.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-pro.16xlarge
     *         </p>
     *         </li>
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The desired capacity for the fleet.
     * </p>
     * 
     * @return The desired capacity for the fleet.
     */
    public ComputeCapacity computeCapacity() {
        return computeCapacity;
    }

    /**
     * <p>
     * The VPC configuration for the fleet.
     * </p>
     * 
     * @return The VPC configuration for the fleet.
     */
    public VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The maximum time that a streaming session can run, in seconds. Specify a value between 600 and 57600.
     * </p>
     * 
     * @return The maximum time that a streaming session can run, in seconds. Specify a value between 600 and 57600.
     */
    public Integer maxUserDurationInSeconds() {
        return maxUserDurationInSeconds;
    }

    /**
     * <p>
     * The time after disconnection when a session is considered to have ended, in seconds. If a user who was
     * disconnected reconnects within this time interval, the user is connected to their previous session. Specify a
     * value between 60 and 57600.
     * </p>
     * 
     * @return The time after disconnection when a session is considered to have ended, in seconds. If a user who was
     *         disconnected reconnects within this time interval, the user is connected to their previous session.
     *         Specify a value between 60 and 57600.
     */
    public Integer disconnectTimeoutInSeconds() {
        return disconnectTimeoutInSeconds;
    }

    /**
     * <p>
     * Deletes the VPC association for the specified fleet.
     * </p>
     * 
     * @return Deletes the VPC association for the specified fleet.
     */
    public Boolean deleteVpcConfig() {
        return deleteVpcConfig;
    }

    /**
     * <p>
     * The description displayed to end users.
     * </p>
     * 
     * @return The description displayed to end users.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The fleet name displayed to end users.
     * </p>
     * 
     * @return The fleet name displayed to end users.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * Enables or disables default internet access for the fleet.
     * </p>
     * 
     * @return Enables or disables default internet access for the fleet.
     */
    public Boolean enableDefaultInternetAccess() {
        return enableDefaultInternetAccess;
    }

    /**
     * <p>
     * The information needed for streaming instances to join a domain.
     * </p>
     * 
     * @return The information needed for streaming instances to join a domain.
     */
    public DomainJoinInfo domainJoinInfo() {
        return domainJoinInfo;
    }

    /**
     * <p>
     * The fleet attributes to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The fleet attributes to delete.
     */
    public List<FleetAttribute> attributesToDelete() {
        return TypeConverter.convert(attributesToDelete, FleetAttribute::fromValue);
    }

    /**
     * <p>
     * The fleet attributes to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The fleet attributes to delete.
     */
    public List<String> attributesToDeleteStrings() {
        return attributesToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(imageName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(computeCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(maxUserDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(disconnectTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(deleteVpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(enableDefaultInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(domainJoinInfo());
        hashCode = 31 * hashCode + Objects.hashCode(attributesToDeleteStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFleetRequest)) {
            return false;
        }
        UpdateFleetRequest other = (UpdateFleetRequest) obj;
        return Objects.equals(imageName(), other.imageName()) && Objects.equals(name(), other.name())
                && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(computeCapacity(), other.computeCapacity()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(maxUserDurationInSeconds(), other.maxUserDurationInSeconds())
                && Objects.equals(disconnectTimeoutInSeconds(), other.disconnectTimeoutInSeconds())
                && Objects.equals(deleteVpcConfig(), other.deleteVpcConfig())
                && Objects.equals(description(), other.description()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(enableDefaultInternetAccess(), other.enableDefaultInternetAccess())
                && Objects.equals(domainJoinInfo(), other.domainJoinInfo())
                && Objects.equals(attributesToDeleteStrings(), other.attributesToDeleteStrings());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (imageName() != null) {
            sb.append("ImageName: ").append(imageName()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (computeCapacity() != null) {
            sb.append("ComputeCapacity: ").append(computeCapacity()).append(",");
        }
        if (vpcConfig() != null) {
            sb.append("VpcConfig: ").append(vpcConfig()).append(",");
        }
        if (maxUserDurationInSeconds() != null) {
            sb.append("MaxUserDurationInSeconds: ").append(maxUserDurationInSeconds()).append(",");
        }
        if (disconnectTimeoutInSeconds() != null) {
            sb.append("DisconnectTimeoutInSeconds: ").append(disconnectTimeoutInSeconds()).append(",");
        }
        if (deleteVpcConfig() != null) {
            sb.append("DeleteVpcConfig: ").append(deleteVpcConfig()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (displayName() != null) {
            sb.append("DisplayName: ").append(displayName()).append(",");
        }
        if (enableDefaultInternetAccess() != null) {
            sb.append("EnableDefaultInternetAccess: ").append(enableDefaultInternetAccess()).append(",");
        }
        if (domainJoinInfo() != null) {
            sb.append("DomainJoinInfo: ").append(domainJoinInfo()).append(",");
        }
        if (attributesToDeleteStrings() != null) {
            sb.append("AttributesToDelete: ").append(attributesToDeleteStrings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageName":
            return Optional.of(clazz.cast(imageName()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "InstanceType":
            return Optional.of(clazz.cast(instanceType()));
        case "ComputeCapacity":
            return Optional.of(clazz.cast(computeCapacity()));
        case "VpcConfig":
            return Optional.of(clazz.cast(vpcConfig()));
        case "MaxUserDurationInSeconds":
            return Optional.of(clazz.cast(maxUserDurationInSeconds()));
        case "DisconnectTimeoutInSeconds":
            return Optional.of(clazz.cast(disconnectTimeoutInSeconds()));
        case "DeleteVpcConfig":
            return Optional.of(clazz.cast(deleteVpcConfig()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "DisplayName":
            return Optional.of(clazz.cast(displayName()));
        case "EnableDefaultInternetAccess":
            return Optional.of(clazz.cast(enableDefaultInternetAccess()));
        case "DomainJoinInfo":
            return Optional.of(clazz.cast(domainJoinInfo()));
        case "AttributesToDelete":
            return Optional.of(clazz.cast(attributesToDeleteStrings()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateFleetRequest> {
        /**
         * <p>
         * The name of the image used by the fleet.
         * </p>
         * 
         * @param imageName
         *        The name of the image used by the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageName(String imageName);

        /**
         * <p>
         * A unique name for the fleet.
         * </p>
         * 
         * @param name
         *        A unique name for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The instance type to use when launching fleet instances. The following instance types are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * stream.standard.medium
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.standard.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.compute.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.compute.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.compute.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.compute.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.compute.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-design.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-design.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-design.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-design.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-desktop.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-pro.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-pro.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-pro.16xlarge
         * </p>
         * </li>
         * </ul>
         * 
         * @param instanceType
         *        The instance type to use when launching fleet instances. The following instance types are
         *        available:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        stream.standard.medium
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.standard.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.compute.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.compute.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.compute.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.compute.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.compute.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-design.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-design.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-design.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-design.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-desktop.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-pro.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-pro.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-pro.16xlarge
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The desired capacity for the fleet.
         * </p>
         * 
         * @param computeCapacity
         *        The desired capacity for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeCapacity(ComputeCapacity computeCapacity);

        /**
         * <p>
         * The desired capacity for the fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link ComputeCapacity.Builder} avoiding the need to
         * create one manually via {@link ComputeCapacity#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComputeCapacity.Builder#build()} is called immediately and its
         * result is passed to {@link #computeCapacity(ComputeCapacity)}.
         * 
         * @param computeCapacity
         *        a consumer that will call methods on {@link ComputeCapacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeCapacity(ComputeCapacity)
         */
        default Builder computeCapacity(Consumer<ComputeCapacity.Builder> computeCapacity) {
            return computeCapacity(ComputeCapacity.builder().apply(computeCapacity).build());
        }

        /**
         * <p>
         * The VPC configuration for the fleet.
         * </p>
         * 
         * @param vpcConfig
         *        The VPC configuration for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * The VPC configuration for the fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfig.Builder} avoiding the need to create
         * one manually via {@link VpcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().apply(vpcConfig).build());
        }

        /**
         * <p>
         * The maximum time that a streaming session can run, in seconds. Specify a value between 600 and 57600.
         * </p>
         * 
         * @param maxUserDurationInSeconds
         *        The maximum time that a streaming session can run, in seconds. Specify a value between 600 and 57600.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds);

        /**
         * <p>
         * The time after disconnection when a session is considered to have ended, in seconds. If a user who was
         * disconnected reconnects within this time interval, the user is connected to their previous session. Specify a
         * value between 60 and 57600.
         * </p>
         * 
         * @param disconnectTimeoutInSeconds
         *        The time after disconnection when a session is considered to have ended, in seconds. If a user who was
         *        disconnected reconnects within this time interval, the user is connected to their previous session.
         *        Specify a value between 60 and 57600.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds);

        /**
         * <p>
         * Deletes the VPC association for the specified fleet.
         * </p>
         * 
         * @param deleteVpcConfig
         *        Deletes the VPC association for the specified fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteVpcConfig(Boolean deleteVpcConfig);

        /**
         * <p>
         * The description displayed to end users.
         * </p>
         * 
         * @param description
         *        The description displayed to end users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The fleet name displayed to end users.
         * </p>
         * 
         * @param displayName
         *        The fleet name displayed to end users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * Enables or disables default internet access for the fleet.
         * </p>
         * 
         * @param enableDefaultInternetAccess
         *        Enables or disables default internet access for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess);

        /**
         * <p>
         * The information needed for streaming instances to join a domain.
         * </p>
         * 
         * @param domainJoinInfo
         *        The information needed for streaming instances to join a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainJoinInfo(DomainJoinInfo domainJoinInfo);

        /**
         * <p>
         * The information needed for streaming instances to join a domain.
         * </p>
         * This is a convenience that creates an instance of the {@link DomainJoinInfo.Builder} avoiding the need to
         * create one manually via {@link DomainJoinInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainJoinInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #domainJoinInfo(DomainJoinInfo)}.
         * 
         * @param domainJoinInfo
         *        a consumer that will call methods on {@link DomainJoinInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainJoinInfo(DomainJoinInfo)
         */
        default Builder domainJoinInfo(Consumer<DomainJoinInfo.Builder> domainJoinInfo) {
            return domainJoinInfo(DomainJoinInfo.builder().apply(domainJoinInfo).build());
        }

        /**
         * <p>
         * The fleet attributes to delete.
         * </p>
         * 
         * @param attributesToDelete
         *        The fleet attributes to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToDelete(Collection<String> attributesToDelete);

        /**
         * <p>
         * The fleet attributes to delete.
         * </p>
         * 
         * @param attributesToDelete
         *        The fleet attributes to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToDelete(String... attributesToDelete);
    }

    static final class BuilderImpl implements Builder {
        private String imageName;

        private String name;

        private String instanceType;

        private ComputeCapacity computeCapacity;

        private VpcConfig vpcConfig;

        private Integer maxUserDurationInSeconds;

        private Integer disconnectTimeoutInSeconds;

        private Boolean deleteVpcConfig;

        private String description;

        private String displayName;

        private Boolean enableDefaultInternetAccess;

        private DomainJoinInfo domainJoinInfo;

        private List<String> attributesToDelete;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFleetRequest model) {
            imageName(model.imageName);
            name(model.name);
            instanceType(model.instanceType);
            computeCapacity(model.computeCapacity);
            vpcConfig(model.vpcConfig);
            maxUserDurationInSeconds(model.maxUserDurationInSeconds);
            disconnectTimeoutInSeconds(model.disconnectTimeoutInSeconds);
            deleteVpcConfig(model.deleteVpcConfig);
            description(model.description);
            displayName(model.displayName);
            enableDefaultInternetAccess(model.enableDefaultInternetAccess);
            domainJoinInfo(model.domainJoinInfo);
            attributesToDelete(model.attributesToDelete);
        }

        public final String getImageName() {
            return imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final ComputeCapacity.Builder getComputeCapacity() {
            return computeCapacity != null ? computeCapacity.toBuilder() : null;
        }

        @Override
        public final Builder computeCapacity(ComputeCapacity computeCapacity) {
            this.computeCapacity = computeCapacity;
            return this;
        }

        public final void setComputeCapacity(ComputeCapacity.BuilderImpl computeCapacity) {
            this.computeCapacity = computeCapacity != null ? computeCapacity.build() : null;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final Integer getMaxUserDurationInSeconds() {
            return maxUserDurationInSeconds;
        }

        @Override
        public final Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
            return this;
        }

        public final void setMaxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
        }

        public final Integer getDisconnectTimeoutInSeconds() {
            return disconnectTimeoutInSeconds;
        }

        @Override
        public final Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
            return this;
        }

        public final void setDisconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
        }

        public final Boolean getDeleteVpcConfig() {
            return deleteVpcConfig;
        }

        @Override
        public final Builder deleteVpcConfig(Boolean deleteVpcConfig) {
            this.deleteVpcConfig = deleteVpcConfig;
            return this;
        }

        public final void setDeleteVpcConfig(Boolean deleteVpcConfig) {
            this.deleteVpcConfig = deleteVpcConfig;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        public final DomainJoinInfo.Builder getDomainJoinInfo() {
            return domainJoinInfo != null ? domainJoinInfo.toBuilder() : null;
        }

        @Override
        public final Builder domainJoinInfo(DomainJoinInfo domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo;
            return this;
        }

        public final void setDomainJoinInfo(DomainJoinInfo.BuilderImpl domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo != null ? domainJoinInfo.build() : null;
        }

        public final Collection<String> getAttributesToDelete() {
            return attributesToDelete;
        }

        @Override
        public final Builder attributesToDelete(Collection<String> attributesToDelete) {
            this.attributesToDelete = FleetAttributesCopier.copy(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDelete(String... attributesToDelete) {
            attributesToDelete(Arrays.asList(attributesToDelete));
            return this;
        }

        public final void setAttributesToDelete(Collection<String> attributesToDelete) {
            this.attributesToDelete = FleetAttributesCopier.copy(attributesToDelete);
        }

        @Override
        public UpdateFleetRequest build() {
            return new UpdateFleetRequest(this);
        }
    }
}
