/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeFleetsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeFleetsResponse.Builder, DescribeFleetsResponse> {
    private final List<Fleet> fleets;

    private final String nextToken;

    private DescribeFleetsResponse(BuilderImpl builder) {
        this.fleets = builder.fleets;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the fleets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the fleets.
     */
    public List<Fleet> fleets() {
        return fleets;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fleets());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetsResponse)) {
            return false;
        }
        DescribeFleetsResponse other = (DescribeFleetsResponse) obj;
        return Objects.equals(fleets(), other.fleets()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (fleets() != null) {
            sb.append("Fleets: ").append(fleets()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fleets":
            return Optional.of(clazz.cast(fleets()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeFleetsResponse> {
        /**
         * <p>
         * Information about the fleets.
         * </p>
         * 
         * @param fleets
         *        Information about the fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleets(Collection<Fleet> fleets);

        /**
         * <p>
         * Information about the fleets.
         * </p>
         * 
         * @param fleets
         *        Information about the fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleets(Fleet... fleets);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<Fleet> fleets;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetsResponse model) {
            fleets(model.fleets);
            nextToken(model.nextToken);
        }

        public final Collection<Fleet.Builder> getFleets() {
            return fleets != null ? fleets.stream().map(Fleet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fleets(Collection<Fleet> fleets) {
            this.fleets = FleetListCopier.copy(fleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleets(Fleet... fleets) {
            fleets(Arrays.asList(fleets));
            return this;
        }

        public final void setFleets(Collection<Fleet.BuilderImpl> fleets) {
            this.fleets = FleetListCopier.copyFromBuilder(fleets);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeFleetsResponse build() {
            return new DescribeFleetsResponse(this);
        }
    }
}
