/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteImageResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DeleteImageResponse.Builder, DeleteImageResponse> {
    private final Image image;

    private DeleteImageResponse(BuilderImpl builder) {
        this.image = builder.image;
    }

    /**
     * Returns the value of the Image property for this object.
     * 
     * @return The value of the Image property for this object.
     */
    public Image image() {
        return image;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(image());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteImageResponse)) {
            return false;
        }
        DeleteImageResponse other = (DeleteImageResponse) obj;
        return Objects.equals(image(), other.image());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (image() != null) {
            sb.append("Image: ").append(image()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Image":
            return Optional.of(clazz.cast(image()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteImageResponse> {
        /**
         * Sets the value of the Image property for this object.
         *
         * @param image
         *        The new value for the Image property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(Image image);

        /**
         * Sets the value of the Image property for this object.
         *
         * This is a convenience that creates an instance of the {@link Image.Builder} avoiding the need to create one
         * manually via {@link Image#builder()}.
         *
         * When the {@link Consumer} completes, {@link Image.Builder#build()} is called immediately and its result is
         * passed to {@link #image(Image)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link Image.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(Image)
         */
        default Builder image(Consumer<Image.Builder> image) {
            return image(Image.builder().apply(image).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Image image;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteImageResponse model) {
            image(model.image);
        }

        public final Image.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final void setImage(Image.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public DeleteImageResponse build() {
            return new DeleteImageResponse(this);
        }
    }
}
