/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateStackRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateStackRequest.Builder, CreateStackRequest> {
    private final String name;

    private final String description;

    private final String displayName;

    private final List<StorageConnector> storageConnectors;

    private CreateStackRequest(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.storageConnectors = builder.storageConnectors;
    }

    /**
     * <p>
     * The name of the stack.
     * </p>
     * 
     * @return The name of the stack.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description displayed to end users.
     * </p>
     * 
     * @return The description displayed to end users.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The stack name displayed to end users.
     * </p>
     * 
     * @return The stack name displayed to end users.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The storage connectors to enable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The storage connectors to enable.
     */
    public List<StorageConnector> storageConnectors() {
        return storageConnectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(storageConnectors());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackRequest)) {
            return false;
        }
        CreateStackRequest other = (CreateStackRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(storageConnectors(), other.storageConnectors());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (displayName() != null) {
            sb.append("DisplayName: ").append(displayName()).append(",");
        }
        if (storageConnectors() != null) {
            sb.append("StorageConnectors: ").append(storageConnectors()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "DisplayName":
            return Optional.of(clazz.cast(displayName()));
        case "StorageConnectors":
            return Optional.of(clazz.cast(storageConnectors()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateStackRequest> {
        /**
         * <p>
         * The name of the stack.
         * </p>
         * 
         * @param name
         *        The name of the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description displayed to end users.
         * </p>
         * 
         * @param description
         *        The description displayed to end users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The stack name displayed to end users.
         * </p>
         * 
         * @param displayName
         *        The stack name displayed to end users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The storage connectors to enable.
         * </p>
         * 
         * @param storageConnectors
         *        The storage connectors to enable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConnectors(Collection<StorageConnector> storageConnectors);

        /**
         * <p>
         * The storage connectors to enable.
         * </p>
         * 
         * @param storageConnectors
         *        The storage connectors to enable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConnectors(StorageConnector... storageConnectors);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String displayName;

        private List<StorageConnector> storageConnectors;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackRequest model) {
            name(model.name);
            description(model.description);
            displayName(model.displayName);
            storageConnectors(model.storageConnectors);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Collection<StorageConnector.Builder> getStorageConnectors() {
            return storageConnectors != null ? storageConnectors.stream().map(StorageConnector::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector... storageConnectors) {
            storageConnectors(Arrays.asList(storageConnectors));
            return this;
        }

        public final void setStorageConnectors(Collection<StorageConnector.BuilderImpl> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copyFromBuilder(storageConnectors);
        }

        @Override
        public CreateStackRequest build() {
            return new CreateStackRequest(this);
        }
    }
}
